/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.economy;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.economy.EconomyManager;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class EconomySyncManager {
    private final EcoXpertPlugin plugin;
    private final EconomyManager ecoXpertEconomy;
    private final Economy fallbackEconomy;
    private final Map<UUID, BigDecimal> lastKnownBalances = new ConcurrentHashMap<UUID, BigDecimal>();
    private final Map<UUID, Long> lastSyncTimes = new ConcurrentHashMap<UUID, Long>();
    private boolean syncEnabled = false;
    private int syncTaskId = -1;
    private final long SYNC_INTERVAL_TICKS = 1200L;
    private final long MIN_SYNC_INTERVAL_MS = 5000L;

    public EconomySyncManager(EcoXpertPlugin plugin, EconomyManager ecoXpertEconomy, Economy fallbackEconomy) {
        this.plugin = plugin;
        this.ecoXpertEconomy = ecoXpertEconomy;
        this.fallbackEconomy = fallbackEconomy;
    }

    public boolean startSync() {
        if (this.syncEnabled) {
            this.plugin.getLogger().info("Economy sync already running");
            return true;
        }
        if (this.fallbackEconomy == null) {
            this.plugin.getLogger().warning("Cannot start economy sync - no fallback economy provider");
            return false;
        }
        try {
            this.performInitialSync();
            this.syncTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::performPeriodicSync, 1200L, 1200L).getTaskId();
            this.syncEnabled = true;
            this.plugin.getLogger().info("Economy synchronization started with " + this.fallbackEconomy.getClass().getSimpleName());
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to start economy sync", e);
            return false;
        }
    }

    public void stopSync() {
        if (!this.syncEnabled) {
            return;
        }
        if (this.syncTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.syncTaskId);
            this.syncTaskId = -1;
        }
        this.syncEnabled = false;
        this.lastKnownBalances.clear();
        this.lastSyncTimes.clear();
        this.plugin.getLogger().info("Economy synchronization stopped");
    }

    private void performInitialSync() {
        this.plugin.getLogger().info("Performing initial economy synchronization...");
        try {
            for (OfflinePlayer player : Bukkit.getOnlinePlayers()) {
                this.syncPlayerBalance(player, true);
            }
            this.plugin.getLogger().info("Initial economy synchronization completed");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error during initial economy sync", e);
        }
    }

    private void performPeriodicSync() {
        if (!this.syncEnabled) {
            return;
        }
        try {
            for (OfflinePlayer player : Bukkit.getOnlinePlayers()) {
                this.syncPlayerBalance(player, false);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error during periodic economy sync", e);
        }
    }

    private void syncPlayerBalance(OfflinePlayer player, boolean forceSync) {
        Long lastSync;
        UUID playerId = player.getUniqueId();
        if (!forceSync && (lastSync = this.lastSyncTimes.get(playerId)) != null && System.currentTimeMillis() - lastSync < 5000L) {
            return;
        }
        try {
            double fallbackBalance = this.fallbackEconomy.getBalance(player);
            BigDecimal fallbackBalanceBD = BigDecimal.valueOf(fallbackBalance);
            BigDecimal lastKnown = this.lastKnownBalances.get(playerId);
            if (lastKnown == null || !lastKnown.equals(fallbackBalanceBD)) {
                CompletionStage syncFuture = this.ecoXpertEconomy.hasAccount(playerId).thenCompose(hasAccount -> {
                    if (!hasAccount.booleanValue()) {
                        return this.ecoXpertEconomy.createAccount(playerId, fallbackBalanceBD);
                    }
                    return this.ecoXpertEconomy.setBalance(playerId, fallbackBalanceBD, "Sync from " + this.fallbackEconomy.getClass().getSimpleName());
                });
                ((CompletableFuture)((CompletableFuture)syncFuture).thenRun(() -> {
                    this.lastKnownBalances.put(playerId, fallbackBalanceBD);
                    this.lastSyncTimes.put(playerId, System.currentTimeMillis());
                    if (this.plugin.getLogger().isLoggable(Level.FINE)) {
                        this.plugin.getLogger().fine("Synced balance for " + player.getName() + ": " + this.ecoXpertEconomy.formatMoney(fallbackBalanceBD));
                    }
                })).exceptionally(throwable -> {
                    this.plugin.getLogger().warning("Failed to sync balance for " + player.getName() + ": " + throwable.getMessage());
                    return null;
                });
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error syncing balance for player " + player.getName(), e);
        }
    }

    public CompletableFuture<Void> syncPlayer(OfflinePlayer player) {
        return CompletableFuture.runAsync(() -> this.syncPlayerBalance(player, true));
    }

    public CompletableFuture<Integer> importBalancesFromFallback() {
        return CompletableFuture.supplyAsync(() -> {
            int importedCount = 0;
            try {
                this.plugin.getLogger().info("Starting balance import from fallback economy...");
                for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
                    if (!player.hasPlayedBefore()) continue;
                    try {
                        double balance = this.fallbackEconomy.getBalance(player);
                        if (!(balance > 0.0)) continue;
                        BigDecimal balanceBD = BigDecimal.valueOf(balance);
                        ((CompletableFuture)this.ecoXpertEconomy.hasAccount(player.getUniqueId()).thenCompose(hasAccount -> {
                            if (!hasAccount.booleanValue()) {
                                return this.ecoXpertEconomy.createAccount(player.getUniqueId(), balanceBD);
                            }
                            return this.ecoXpertEconomy.setBalance(player.getUniqueId(), balanceBD, "Imported from fallback economy");
                        })).join();
                        this.lastKnownBalances.put(player.getUniqueId(), balanceBD);
                        ++importedCount;
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to import balance for " + player.getName() + ": " + e.getMessage());
                    }
                }
                this.plugin.getLogger().info("Balance import completed. Imported " + importedCount + " accounts");
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error during balance import", e);
            }
            return importedCount;
        });
    }

    public SyncStatistics getStatistics() {
        return new SyncStatistics(this.syncEnabled, this.lastKnownBalances.size(), this.lastSyncTimes.size(), this.fallbackEconomy != null ? this.fallbackEconomy.getClass().getSimpleName() : "None");
    }

    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public Economy getFallbackEconomy() {
        return this.fallbackEconomy;
    }

    public static class SyncStatistics {
        private final boolean syncEnabled;
        private final int trackedBalances;
        private final int syncedPlayers;
        private final String fallbackProviderName;

        public SyncStatistics(boolean syncEnabled, int trackedBalances, int syncedPlayers, String fallbackProviderName) {
            this.syncEnabled = syncEnabled;
            this.trackedBalances = trackedBalances;
            this.syncedPlayers = syncedPlayers;
            this.fallbackProviderName = fallbackProviderName;
        }

        public boolean isSyncEnabled() {
            return this.syncEnabled;
        }

        public int getTrackedBalances() {
            return this.trackedBalances;
        }

        public int getSyncedPlayers() {
            return this.syncedPlayers;
        }

        public String getFallbackProviderName() {
            return this.fallbackProviderName;
        }

        public String toString() {
            return String.format("SyncStats{enabled=%s, tracked=%d, synced=%d, provider=%s}", this.syncEnabled, this.trackedBalances, this.syncedPlayers, this.fallbackProviderName);
        }
    }
}

