/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.economy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.ServiceRegistry;
import me.koyere.ecoxpert.core.economy.EconomyConflictDetector;
import me.koyere.ecoxpert.core.economy.EconomyModeManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.economy.VaultEconomyProvider;
import me.koyere.ecoxpert.economy.VaultEconomyProviderImpl;

public class EconomySystemTestRunner {
    private final EcoXpertPlugin plugin;

    public EconomySystemTestRunner(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    public TestResults runSafeTests() {
        TestResults.Builder results = new TestResults.Builder();
        try {
            results.addTest("ConflictDetection", this.testConflictDetection());
            results.addTest("ModeManagerInit", this.testModeManagerInitialization());
            results.addTest("VaultProviderSafety", this.testVaultProviderSafety());
            results.addTest("ServiceRegistryIntegration", this.testServiceRegistryIntegration());
            this.plugin.getLogger().info("Economy system tests completed");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during economy system testing: " + e.getMessage());
            results.addTest("TestRunner", TestResult.failure("Test runner error: " + e.getMessage()));
        }
        return results.build();
    }

    private TestResult testConflictDetection() {
        try {
            EconomyConflictDetector detector = new EconomyConflictDetector(this.plugin);
            EconomyConflictDetector.EconomyProviderStatus status = detector.detectEconomyProvider();
            if (status == null) {
                return TestResult.failure("Provider detection returned null");
            }
            EconomyConflictDetector.InstalledEconomyPlugins plugins = detector.detectInstalledEconomyPlugins();
            if (plugins == null) {
                return TestResult.failure("Plugin detection returned null");
            }
            boolean canRegister = detector.canSafelyRegister();
            return TestResult.success(String.format("Detection successful - Status: %s, Plugins: %d, CanRegister: %s", new Object[]{status.getStatus(), plugins.getInstalledCount(), canRegister}));
        }
        catch (Exception e) {
            return TestResult.failure("Conflict detection test failed: " + e.getMessage());
        }
    }

    private TestResult testModeManagerInitialization() {
        try {
            EconomyManager economyManager = this.plugin.getServiceRegistry().getInstance(EconomyManager.class);
            if (economyManager == null) {
                return TestResult.failure("EconomyManager not available in registry");
            }
            VaultEconomyProvider vaultProvider = this.plugin.getServiceRegistry().getInstance(VaultEconomyProvider.class);
            if (vaultProvider == null) {
                return TestResult.failure("VaultEconomyProvider not available in registry");
            }
            EconomyModeManager modeManager = new EconomyModeManager(this.plugin, vaultProvider);
            if (modeManager == null) {
                return TestResult.failure("Failed to create EconomyModeManager");
            }
            if (modeManager.isInitialized()) {
                return TestResult.failure("ModeManager should not be initialized on creation");
            }
            return TestResult.success("ModeManager created successfully - ready for initialization");
        }
        catch (Exception e) {
            return TestResult.failure("Mode manager test failed: " + e.getMessage());
        }
    }

    private TestResult testVaultProviderSafety() {
        try {
            VaultEconomyProvider vaultProvider = this.plugin.getServiceRegistry().getInstance(VaultEconomyProvider.class);
            if (vaultProvider == null) {
                return TestResult.failure("VaultEconomyProvider not available");
            }
            if (!(vaultProvider instanceof VaultEconomyProviderImpl)) {
                return TestResult.failure("VaultProvider is not our enhanced implementation");
            }
            VaultEconomyProviderImpl impl = (VaultEconomyProviderImpl)vaultProvider;
            boolean registered = impl.isRegistered();
            String name = impl.getName();
            return TestResult.success(String.format("VaultProvider basic features working - Registered: %s, Name: %s", registered, name));
        }
        catch (Exception e) {
            return TestResult.failure("Vault provider safety test failed: " + e.getMessage());
        }
    }

    private TestResult testServiceRegistryIntegration() {
        try {
            ServiceRegistry serviceRegistry = this.plugin.getServiceRegistry();
            if (serviceRegistry == null) {
                return TestResult.failure("ServiceRegistry not available");
            }
            EconomyManager economyManager = serviceRegistry.getInstance(EconomyManager.class);
            VaultEconomyProvider vaultProvider = serviceRegistry.getInstance(VaultEconomyProvider.class);
            if (economyManager == null) {
                return TestResult.failure("EconomyManager not available in registry");
            }
            if (vaultProvider == null) {
                return TestResult.failure("VaultEconomyProvider not available in registry");
            }
            return TestResult.success("All required services available in registry");
        }
        catch (Exception e) {
            return TestResult.failure("Service registry test failed: " + e.getMessage());
        }
    }

    public static class TestResults {
        private final Map<String, TestResult> results;
        private final int totalTests;
        private final int passedTests;

        private TestResults(Map<String, TestResult> results) {
            this.results = new HashMap<String, TestResult>(results);
            this.totalTests = results.size();
            this.passedTests = (int)results.values().stream().filter(TestResult::isSuccess).count();
        }

        public TestResult getResult(String testName) {
            return this.results.get(testName);
        }

        public Set<String> getTestNames() {
            return this.results.keySet();
        }

        public int getTotalTests() {
            return this.totalTests;
        }

        public int getPassedTests() {
            return this.passedTests;
        }

        public int getFailedTests() {
            return this.totalTests - this.passedTests;
        }

        public boolean allPassed() {
            return this.passedTests == this.totalTests;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("=== Economy System Test Results ===\n");
            sb.append(String.format("Total: %d, Passed: %d, Failed: %d\n", this.totalTests, this.passedTests, this.getFailedTests()));
            for (Map.Entry<String, TestResult> entry : this.results.entrySet()) {
                sb.append(String.format("%s: %s\n", entry.getKey(), entry.getValue()));
            }
            sb.append("=== End Test Results ===");
            return sb.toString();
        }

        public static class Builder {
            private final Map<String, TestResult> results = new HashMap<String, TestResult>();

            public Builder addTest(String name, TestResult result) {
                this.results.put(name, result);
                return this;
            }

            public TestResults build() {
                return new TestResults(this.results);
            }
        }
    }

    public static class TestResult {
        private final boolean success;
        private final String message;

        private TestResult(boolean success, String message) {
            this.success = success;
            this.message = message;
        }

        public static TestResult success(String message) {
            return new TestResult(true, message);
        }

        public static TestResult failure(String message) {
            return new TestResult(false, message);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return (this.success ? "\u2713 PASS" : "\u2717 FAIL") + ": " + this.message;
        }
    }
}

