/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.core.safety;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class RateLimitManager {
    private final int opsPerSecond;
    private final Map<String, Counter> buckets = new ConcurrentHashMap<String, Counter>();

    public RateLimitManager(int opsPerSecond) {
        this.opsPerSecond = Math.max(1, opsPerSecond);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allow(UUID playerId, String action) {
        Counter c;
        long nowSec = System.currentTimeMillis() / 1000L;
        String key = String.valueOf(playerId) + ":" + action;
        Counter counter = c = this.buckets.computeIfAbsent(key, k -> new Counter(nowSec, 0));
        synchronized (counter) {
            if (c.epochSec != nowSec) {
                c.epochSec = nowSec;
                c.count = 0;
            }
            if (c.count >= this.opsPerSecond) {
                return false;
            }
            ++c.count;
            return true;
        }
    }

    private static class Counter {
        long epochSec;
        int count;

        Counter(long epochSec, int count) {
            this.epochSec = epochSec;
            this.count = count;
        }
    }
}

