/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.economy;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.CompletionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.economy.VaultEconomyProvider;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;

@Singleton
public class VaultEconomyProviderImpl
implements VaultEconomyProvider,
Economy {
    private final EcoXpertPlugin plugin;
    private final EconomyManager economyManager;
    private boolean registered = false;

    @Inject
    public VaultEconomyProviderImpl(EcoXpertPlugin plugin, EconomyManager economyManager) {
        this.plugin = plugin;
        this.economyManager = economyManager;
    }

    @Override
    public boolean register() {
        if (!this.registered) {
            this.plugin.getServer().getServicesManager().register(Economy.class, (Object)this, (Plugin)this.plugin, ServicePriority.Highest);
            this.registered = true;
            this.plugin.getLogger().info("Registered as Vault economy provider");
        }
        return this.registered;
    }

    @Override
    public void unregister() {
        if (this.registered) {
            this.plugin.getServer().getServicesManager().unregister(Economy.class, (Object)this);
            this.registered = false;
            this.plugin.getLogger().info("Unregistered Vault economy provider");
        }
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public String getName() {
        return "EcoXpert Pro";
    }

    public boolean isEnabled() {
        return this.plugin.isEnabled();
    }

    public String format(double amount) {
        return this.economyManager.formatMoney(BigDecimal.valueOf(amount));
    }

    public String currencyNamePlural() {
        return this.economyManager.getCurrencyNamePlural();
    }

    public String currencyNameSingular() {
        return this.economyManager.getCurrencyNameSingular();
    }

    public boolean hasAccount(String playerName) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        return this.hasAccount(player);
    }

    public boolean hasAccount(OfflinePlayer player) {
        try {
            return this.economyManager.hasAccount(player.getUniqueId()).join();
        }
        catch (CompletionException e) {
            this.plugin.getLogger().warning("Error checking account for player " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public double getBalance(String playerName) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        return this.getBalance(player);
    }

    public double getBalance(OfflinePlayer player) {
        try {
            BigDecimal balance = this.economyManager.getBalance(player.getUniqueId()).join();
            return balance.doubleValue();
        }
        catch (CompletionException e) {
            this.plugin.getLogger().warning("Error getting balance for player " + player.getName() + ": " + e.getMessage());
            return 0.0;
        }
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative amount");
        }
        try {
            BigDecimal withdrawAmount = BigDecimal.valueOf(amount);
            boolean success = this.economyManager.removeMoney(player.getUniqueId(), withdrawAmount, "Vault withdrawal").join();
            double newBalance = this.getBalance(player);
            if (success) {
                return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
            }
            return new EconomyResponse(0.0, newBalance, EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        catch (CompletionException e) {
            this.plugin.getLogger().warning("Error withdrawing from player " + player.getName() + ": " + e.getMessage());
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Database error: " + e.getMessage());
        }
    }

    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative amount");
        }
        try {
            BigDecimal depositAmount = BigDecimal.valueOf(amount);
            this.economyManager.addMoney(player.getUniqueId(), depositAmount, "Vault deposit").join();
            double newBalance = this.getBalance(player);
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, null);
        }
        catch (CompletionException e) {
            this.plugin.getLogger().warning("Error depositing to player " + player.getName() + ": " + e.getMessage());
            return new EconomyResponse(0.0, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Database error: " + e.getMessage());
        }
    }

    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented - use /bank for personal accounts");
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented - use /bank for personal accounts");
    }

    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "Shared bank accounts not yet implemented");
    }

    public List<String> getBanks() {
        return List.of();
    }

    public boolean createPlayerAccount(String playerName) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        return this.createPlayerAccount(player);
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        try {
            if (!this.hasAccount(player)) {
                this.economyManager.createAccount(player.getUniqueId(), this.economyManager.getStartingBalance()).join();
            }
            return true;
        }
        catch (CompletionException e) {
            this.plugin.getLogger().warning("Error creating account for player " + player.getName() + ": " + e.getMessage());
            return false;
        }
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }

    public int fractionalDigits() {
        return 2;
    }

    public boolean hasBankSupport() {
        return false;
    }
}

