/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import me.koyere.ecoxpert.modules.bank.BankAccountTier;
import me.koyere.ecoxpert.modules.bank.BankTransactionType;

public class BankAccount {
    private final UUID playerId;
    private final String accountNumber;
    private BigDecimal balance;
    private BankAccountTier tier;
    private LocalDateTime createdAt;
    private LocalDateTime lastInterestCalculation;
    private BigDecimal totalInterestEarned;
    private boolean frozen;
    private String frozenReason;
    private LocalDate lastResetDate;
    private BigDecimal dailyDepositUsed;
    private BigDecimal dailyWithdrawUsed;
    private BigDecimal dailyTransferUsed;
    private int failedTransactionCount;
    private LocalDateTime lastFailedTransaction;

    public BankAccount(UUID playerId, String accountNumber, BankAccountTier tier) {
        this.playerId = playerId;
        this.accountNumber = accountNumber;
        this.balance = BigDecimal.ZERO;
        this.tier = tier;
        this.createdAt = LocalDateTime.now();
        this.lastInterestCalculation = LocalDateTime.now();
        this.totalInterestEarned = BigDecimal.ZERO;
        this.frozen = false;
        this.frozenReason = null;
        this.lastResetDate = LocalDate.now();
        this.dailyDepositUsed = BigDecimal.ZERO;
        this.dailyWithdrawUsed = BigDecimal.ZERO;
        this.dailyTransferUsed = BigDecimal.ZERO;
        this.failedTransactionCount = 0;
        this.lastFailedTransaction = null;
    }

    public void addBalance(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) > 0) {
            this.balance = this.balance.add(amount);
        }
    }

    public boolean subtractBalance(BigDecimal amount) {
        if (amount.compareTo(BigDecimal.ZERO) > 0 && this.balance.compareTo(amount) >= 0) {
            this.balance = this.balance.subtract(amount);
            return true;
        }
        return false;
    }

    public boolean hasSufficientFunds(BigDecimal amount) {
        return this.balance.compareTo(amount) >= 0;
    }

    public void addInterest(BigDecimal interestAmount) {
        if (interestAmount.compareTo(BigDecimal.ZERO) > 0) {
            this.balance = this.balance.add(interestAmount);
            this.totalInterestEarned = this.totalInterestEarned.add(interestAmount);
            this.lastInterestCalculation = LocalDateTime.now();
        }
    }

    public boolean isInterestCalculationDue() {
        LocalDateTime yesterday = LocalDateTime.now().minusDays(1L);
        return this.lastInterestCalculation.isBefore(yesterday);
    }

    public void checkAndResetDailyLimits() {
        LocalDate today = LocalDate.now();
        if (!this.lastResetDate.equals(today)) {
            this.dailyDepositUsed = BigDecimal.ZERO;
            this.dailyWithdrawUsed = BigDecimal.ZERO;
            this.dailyTransferUsed = BigDecimal.ZERO;
            this.lastResetDate = today;
        }
    }

    public boolean isWithinDailyLimit(BankTransactionType type, BigDecimal amount) {
        this.checkAndResetDailyLimits();
        BigDecimal currentUsed = switch (type) {
            case BankTransactionType.DEPOSIT -> this.dailyDepositUsed;
            case BankTransactionType.WITHDRAW -> this.dailyWithdrawUsed;
            case BankTransactionType.TRANSFER_OUT -> this.dailyTransferUsed;
            default -> BigDecimal.ZERO;
        };
        BigDecimal dailyLimit = this.tier.getDailyLimit(type);
        return currentUsed.add(amount).compareTo(dailyLimit) <= 0;
    }

    public void addToDailyUsage(BankTransactionType type, BigDecimal amount) {
        this.checkAndResetDailyLimits();
        switch (type) {
            case DEPOSIT: {
                this.dailyDepositUsed = this.dailyDepositUsed.add(amount);
                break;
            }
            case WITHDRAW: {
                this.dailyWithdrawUsed = this.dailyWithdrawUsed.add(amount);
                break;
            }
            case TRANSFER_OUT: {
                this.dailyTransferUsed = this.dailyTransferUsed.add(amount);
            }
        }
    }

    public BigDecimal getRemainingDailyLimit(BankTransactionType type) {
        this.checkAndResetDailyLimits();
        BigDecimal currentUsed = switch (type) {
            case BankTransactionType.DEPOSIT -> this.dailyDepositUsed;
            case BankTransactionType.WITHDRAW -> this.dailyWithdrawUsed;
            case BankTransactionType.TRANSFER_OUT -> this.dailyTransferUsed;
            default -> BigDecimal.ZERO;
        };
        BigDecimal dailyLimit = this.tier.getDailyLimit(type);
        return dailyLimit.subtract(currentUsed).max(BigDecimal.ZERO);
    }

    public void recordFailedTransaction() {
        ++this.failedTransactionCount;
        this.lastFailedTransaction = LocalDateTime.now();
        if (this.failedTransactionCount >= 10) {
            this.frozen = true;
            this.frozenReason = "Too many failed transactions - auto-frozen for security";
        }
    }

    public void resetFailedTransactionCount() {
        this.failedTransactionCount = 0;
        this.lastFailedTransaction = null;
    }

    public void freeze(String reason) {
        this.frozen = true;
        this.frozenReason = reason;
    }

    public void unfreeze() {
        this.frozen = false;
        this.frozenReason = null;
        this.resetFailedTransactionCount();
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public BankAccountTier getTier() {
        return this.tier;
    }

    public void setTier(BankAccountTier tier) {
        this.tier = tier;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public LocalDateTime getLastInterestCalculation() {
        return this.lastInterestCalculation;
    }

    public void setLastInterestCalculation(LocalDateTime lastInterestCalculation) {
        this.lastInterestCalculation = lastInterestCalculation;
    }

    public BigDecimal getTotalInterestEarned() {
        return this.totalInterestEarned;
    }

    public void setTotalInterestEarned(BigDecimal totalInterestEarned) {
        this.totalInterestEarned = totalInterestEarned;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public String getFrozenReason() {
        return this.frozenReason;
    }

    public void setFrozenReason(String frozenReason) {
        this.frozenReason = frozenReason;
    }

    public LocalDate getLastResetDate() {
        return this.lastResetDate;
    }

    public void setLastResetDate(LocalDate lastResetDate) {
        this.lastResetDate = lastResetDate;
    }

    public BigDecimal getDailyDepositUsed() {
        return this.dailyDepositUsed;
    }

    public void setDailyDepositUsed(BigDecimal dailyDepositUsed) {
        this.dailyDepositUsed = dailyDepositUsed;
    }

    public BigDecimal getDailyWithdrawUsed() {
        return this.dailyWithdrawUsed;
    }

    public void setDailyWithdrawUsed(BigDecimal dailyWithdrawUsed) {
        this.dailyWithdrawUsed = dailyWithdrawUsed;
    }

    public BigDecimal getDailyTransferUsed() {
        return this.dailyTransferUsed;
    }

    public void setDailyTransferUsed(BigDecimal dailyTransferUsed) {
        this.dailyTransferUsed = dailyTransferUsed;
    }

    public int getFailedTransactionCount() {
        return this.failedTransactionCount;
    }

    public void setFailedTransactionCount(int failedTransactionCount) {
        this.failedTransactionCount = failedTransactionCount;
    }

    public LocalDateTime getLastFailedTransaction() {
        return this.lastFailedTransaction;
    }

    public void setLastFailedTransaction(LocalDateTime lastFailedTransaction) {
        this.lastFailedTransaction = lastFailedTransaction;
    }
}

