/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.util.Arrays;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.gui.BaseGUI;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.bank.BankManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BankGUI
extends BaseGUI {
    private final BankManager bankManager;
    private final EconomyManager economyManager;
    private final TranslationManager tm;

    public BankGUI(EcoXpertPlugin plugin, BankManager bankManager, EconomyManager economyManager, TranslationManager tm) {
        super(plugin);
        this.bankManager = bankManager;
        this.economyManager = economyManager;
        this.tm = tm;
    }

    @Override
    protected Inventory create(Player player) {
        String title = this.tm.getMessage("bank.gui.title", new Object[0]);
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)title);
        inv.setItem(11, this.button(Material.LIME_WOOL, this.tm.getMessage("bank.gui.deposit", new Object[0]) + " +100", new String[]{"\u00a77" + this.tm.getMessage("bank.gui.deposit-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("bank.gui.deposit-lore2", new Object[0])}));
        inv.setItem(12, this.button(Material.LIME_WOOL, this.tm.getMessage("bank.gui.deposit", new Object[0]) + " +1000", new String[]{"\u00a77" + this.tm.getMessage("bank.gui.deposit-fast-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("bank.gui.deposit-fast-lore2", new Object[0])}));
        inv.setItem(13, this.button(Material.PAPER, this.tm.getMessage("bank.gui.balance", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("bank.gui.balance-lore", new Object[0])}));
        inv.setItem(14, this.button(Material.RED_WOOL, this.tm.getMessage("bank.gui.withdraw", new Object[0]) + " -100", new String[]{"\u00a77" + this.tm.getMessage("bank.gui.withdraw-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("bank.gui.withdraw-lore2", new Object[0])}));
        inv.setItem(15, this.button(Material.RED_WOOL, this.tm.getMessage("bank.gui.withdraw", new Object[0]) + " -1000", new String[]{"\u00a77" + this.tm.getMessage("bank.gui.withdraw-fast-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("bank.gui.withdraw-fast-lore2", new Object[0])}));
        return inv;
    }

    private ItemStack button(Material mat, String name, String[] lore) {
        ItemStack it = new ItemStack(mat);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName("\u00a7e" + name);
        if (lore != null) {
            meta.setLore(Arrays.asList(lore));
        }
        it.setItemMeta(meta);
        return it;
    }

    private ItemStack button(Material mat, String name) {
        return this.button(mat, name, null);
    }

    @Override
    protected void onClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack it = e.getCurrentItem();
        if (it == null || !it.hasItemMeta() || !it.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = it.getItemMeta().getDisplayName();
        if (name.contains("+1000")) {
            this.bankManager.deposit(p, new BigDecimal("1000")).thenAccept(r -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + r.getMessage()));
        } else if (name.contains("+100")) {
            this.bankManager.deposit(p, new BigDecimal("100")).thenAccept(r -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + r.getMessage()));
        } else if (name.contains("-1000")) {
            this.bankManager.withdraw(p, new BigDecimal("1000")).thenAccept(r -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + r.getMessage()));
        } else if (name.contains("-100")) {
            this.bankManager.withdraw(p, new BigDecimal("100")).thenAccept(r -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + r.getMessage()));
        } else if (name.contains(this.tm.getMessage("bank.gui.balance", new Object[0]))) {
            this.bankManager.getBalance(p.getUniqueId()).thenAccept(b -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("bank.balance", this.economyManager.formatMoney((BigDecimal)b), new Object[0])));
        }
    }
}

