/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import me.koyere.ecoxpert.modules.bank.BankTransactionType;

public class BankTransaction {
    private final long transactionId;
    private final UUID accountId;
    private final BankTransactionType type;
    private final BigDecimal amount;
    private final BigDecimal balanceBefore;
    private final BigDecimal balanceAfter;
    private final LocalDateTime timestamp;
    private final String description;
    private final String reference;
    private final UUID relatedAccountId;
    private final String adminId;
    private final String ipAddress;
    private final String reason;
    private final String transactionHash;
    private final boolean verified;

    private BankTransaction(Builder builder) {
        this.transactionId = builder.transactionId;
        this.accountId = builder.accountId;
        this.type = builder.type;
        this.amount = builder.amount;
        this.balanceBefore = builder.balanceBefore;
        this.balanceAfter = builder.balanceAfter;
        this.timestamp = builder.timestamp != null ? builder.timestamp : LocalDateTime.now();
        this.description = builder.description;
        this.reference = builder.reference;
        this.relatedAccountId = builder.relatedAccountId;
        this.adminId = builder.adminId;
        this.ipAddress = builder.ipAddress;
        this.reason = builder.reason;
        this.transactionHash = this.generateTransactionHash();
        this.verified = true;
    }

    private String generateTransactionHash() {
        String data = String.format("%d-%s-%s-%s-%s-%s", new Object[]{this.transactionId, this.accountId, this.type, this.amount, this.balanceBefore, this.balanceAfter});
        return String.valueOf(data.hashCode());
    }

    public boolean verifyIntegrity() {
        String expectedHash = this.generateTransactionHash();
        return expectedHash.equals(this.transactionHash);
    }

    public boolean isCredit() {
        return this.type.increasesBalance();
    }

    public boolean isDebit() {
        return this.type.decreasesBalance();
    }

    public String getFormattedDescription() {
        if (this.description != null && !this.description.isEmpty()) {
            return this.description;
        }
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case BankTransactionType.DEPOSIT -> "Deposit to bank account";
            case BankTransactionType.WITHDRAW -> "Withdrawal from bank account";
            case BankTransactionType.TRANSFER_IN -> "Transfer received from " + String.valueOf(this.relatedAccountId != null ? this.relatedAccountId : "unknown");
            case BankTransactionType.TRANSFER_OUT -> "Transfer sent to " + String.valueOf(this.relatedAccountId != null ? this.relatedAccountId : "unknown");
            case BankTransactionType.INTEREST -> "Interest earned";
            case BankTransactionType.FEE -> "Bank fee charged";
            case BankTransactionType.ADMIN_ADJUSTMENT -> "Administrative adjustment" + (String)(this.reason != null ? ": " + this.reason : "");
            case BankTransactionType.FREEZE -> "Account frozen" + (String)(this.reason != null ? ": " + this.reason : "");
            case BankTransactionType.UNFREEZE -> "Account unfrozen";
            case BankTransactionType.TIER_UPGRADE -> "Account tier upgraded";
        };
    }

    public long getAgeInDays() {
        return ChronoUnit.DAYS.between(this.timestamp, LocalDateTime.now());
    }

    public long getTransactionId() {
        return this.transactionId;
    }

    public UUID getAccountId() {
        return this.accountId;
    }

    public BankTransactionType getType() {
        return this.type;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getBalanceBefore() {
        return this.balanceBefore;
    }

    public BigDecimal getBalanceAfter() {
        return this.balanceAfter;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public UUID getRelatedAccountId() {
        return this.relatedAccountId;
    }

    public String getAdminId() {
        return this.adminId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getReason() {
        return this.reason;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public String toString() {
        return String.format("BankTransaction{id=%d, type=%s, amount=%s, account=%s, timestamp=%s}", new Object[]{this.transactionId, this.type, this.amount, this.accountId, this.timestamp});
    }

    public static class Builder {
        private long transactionId;
        private UUID accountId;
        private BankTransactionType type;
        private BigDecimal amount;
        private BigDecimal balanceBefore;
        private BigDecimal balanceAfter;
        private LocalDateTime timestamp;
        private String description;
        private String reference;
        private UUID relatedAccountId;
        private String adminId;
        private String ipAddress;
        private String reason;

        public Builder setTransactionId(long transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder setAccountId(UUID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder setType(BankTransactionType type) {
            this.type = type;
            return this;
        }

        public Builder setAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder setBalanceBefore(BigDecimal balanceBefore) {
            this.balanceBefore = balanceBefore;
            return this;
        }

        public Builder setBalanceAfter(BigDecimal balanceAfter) {
            this.balanceAfter = balanceAfter;
            return this;
        }

        public Builder setTimestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setReference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder setRelatedAccountId(UUID relatedAccountId) {
            this.relatedAccountId = relatedAccountId;
            return this;
        }

        public Builder setAdminId(String adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public Builder setReason(String reason) {
            this.reason = reason;
            return this;
        }

        public BankTransaction build() {
            if (this.accountId == null) {
                throw new IllegalArgumentException("Account ID cannot be null");
            }
            if (this.type == null) {
                throw new IllegalArgumentException("Transaction type cannot be null");
            }
            if (this.amount == null) {
                throw new IllegalArgumentException("Amount cannot be null");
            }
            if (this.balanceBefore == null) {
                throw new IllegalArgumentException("Balance before cannot be null");
            }
            if (this.balanceAfter == null) {
                throw new IllegalArgumentException("Balance after cannot be null");
            }
            BigDecimal expectedBalanceAfter = this.balanceBefore;
            if (this.type.increasesBalance()) {
                expectedBalanceAfter = this.balanceBefore.add(this.amount);
            } else if (this.type.decreasesBalance()) {
                expectedBalanceAfter = this.balanceBefore.subtract(this.amount);
            }
            if (expectedBalanceAfter.compareTo(this.balanceAfter) != 0) {
                throw new IllegalArgumentException("Balance calculation does not match: expected " + String.valueOf(expectedBalanceAfter) + ", got " + String.valueOf(this.balanceAfter));
            }
            return new BankTransaction(this);
        }
    }
}

