/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.bank;

public enum BankTransactionType {
    DEPOSIT("Deposit", "Money deposited to bank account"),
    WITHDRAW("Withdraw", "Money withdrawn from bank account"),
    TRANSFER_IN("Transfer In", "Money transferred from another account"),
    TRANSFER_OUT("Transfer Out", "Money transferred to another account"),
    INTEREST("Interest", "Interest earned on account balance"),
    FEE("Fee", "Bank fee charged"),
    ADMIN_ADJUSTMENT("Admin Adjustment", "Administrative balance adjustment"),
    FREEZE("Freeze", "Account frozen"),
    UNFREEZE("Unfreeze", "Account unfrozen"),
    TIER_UPGRADE("Tier Upgrade", "Account tier upgraded");

    private final String displayName;
    private final String description;

    private BankTransactionType(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public boolean affectsDailyLimits() {
        return switch (this) {
            case DEPOSIT, WITHDRAW, TRANSFER_OUT -> true;
            default -> false;
        };
    }

    public boolean increasesBalance() {
        return switch (this) {
            case DEPOSIT, TRANSFER_IN, INTEREST, ADMIN_ADJUSTMENT -> true;
            default -> false;
        };
    }

    public boolean decreasesBalance() {
        return switch (this) {
            case WITHDRAW, TRANSFER_OUT, FEE -> true;
            case ADMIN_ADJUSTMENT -> false;
            default -> false;
        };
    }

    public boolean requiresApproval() {
        return switch (this) {
            case ADMIN_ADJUSTMENT, FREEZE, UNFREEZE -> true;
            default -> false;
        };
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

