/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.inflation;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.api.events.EconomyCycleChangeEvent;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.education.EducationNotifier;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.inflation.EconomicIntelligenceEngine;
import me.koyere.ecoxpert.modules.inflation.EconomicMemory;
import me.koyere.ecoxpert.modules.inflation.EconomicSnapshot;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import me.koyere.ecoxpert.modules.inflation.PlayerEconomicProfile;
import me.koyere.ecoxpert.modules.market.MarketManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class InflationManagerImpl
implements InflationManager {
    private final EcoXpertPlugin plugin;
    private final EconomyManager economyManager;
    private final MarketManager marketManager;
    private final ConfigManager configManager;
    private EconomicIntelligenceEngine intelligenceEngine;
    private EconomicMemory economicMemory;
    private final Map<UUID, PlayerEconomicProfile> playerProfiles = new ConcurrentHashMap<UUID, PlayerEconomicProfile>();
    private boolean active = false;
    private boolean initialized = false;
    private String lastInterventionDescription = "None";
    private EconomicIntelligenceEngine.EconomicCycle lastBroadcastCycle = EconomicIntelligenceEngine.EconomicCycle.STABLE;

    public InflationManagerImpl(EcoXpertPlugin plugin, EconomyManager economyManager, MarketManager marketManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.economyManager = economyManager;
        this.marketManager = marketManager;
        this.configManager = configManager;
    }

    @Override
    public CompletableFuture<Void> initialize() {
        if (this.initialized) {
            this.plugin.getLogger().info("Inflation Manager already initialized");
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                this.plugin.getLogger().info("\ud83e\udde0 Initializing Revolutionary Economic Intelligence System...");
                this.economicMemory = new EconomicMemory();
                this.intelligenceEngine = new EconomicIntelligenceEngine(this.plugin, this.economyManager, this.marketManager, this.configManager);
                this.intelligenceEngine.initialize().join();
                this.loadPlayerProfiles();
                this.active = true;
                this.initialized = true;
                this.plugin.getLogger().info("\u2705 Economic Intelligence System fully operational");
                this.plugin.getLogger().info("\ud83d\udcca System ready to manage server economy intelligently");
                this.logSystemStatus();
                try {
                    boolean edu;
                    FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getConfig();
                    boolean bl = edu = cfg.getBoolean("education.enabled", true) && cfg.getBoolean("education.broadcasts.cycle", true);
                    if (edu) {
                        long periodTicks = 6000L;
                        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, () -> {
                            try {
                                EconomicIntelligenceEngine.EconomicCycle current = this.getCurrentCycle();
                                if (current != this.lastBroadcastCycle) {
                                    EconomicIntelligenceEngine.EconomicCycle old = this.lastBroadcastCycle;
                                    EducationNotifier.broadcastCycle(this.plugin, this.plugin.getServiceRegistry().getInstance(TranslationManager.class), current);
                                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new EconomyCycleChangeEvent(old, current, Instant.now())));
                                    this.lastBroadcastCycle = current;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }, periodTicks, periodTicks);
                    }
                }
                catch (Exception cfg) {}
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to initialize Inflation Manager: " + e.getMessage());
                this.active = false;
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            this.plugin.getLogger().info("\ud83d\udd0c Shutting down Economic Intelligence System...");
            this.savePlayerProfiles();
            if (this.intelligenceEngine != null) {
                this.intelligenceEngine = null;
            }
            this.active = false;
            this.initialized = false;
            this.plugin.getLogger().info("Economic Intelligence System shutdown complete");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error during Inflation Manager shutdown: " + e.getMessage());
        }
    }

    @Override
    public EconomicIntelligenceEngine.EconomicCycle getCurrentCycle() {
        return this.active && this.intelligenceEngine != null ? this.intelligenceEngine.getCurrentCycle() : EconomicIntelligenceEngine.EconomicCycle.STABLE;
    }

    @Override
    public double getEconomicHealth() {
        return this.active && this.intelligenceEngine != null ? this.intelligenceEngine.getEconomicHealth() : 1.0;
    }

    @Override
    public double getInflationRate() {
        return this.active && this.intelligenceEngine != null ? this.intelligenceEngine.getInflationRate() : 0.0;
    }

    @Override
    public double getVelocityOfMoney() {
        return this.active && this.intelligenceEngine != null ? this.intelligenceEngine.getVelocityOfMoney() : 1.0;
    }

    @Override
    public CompletableFuture<EconomicSnapshot> getCurrentSnapshot() {
        if (!this.active || this.intelligenceEngine == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> new EconomicSnapshot(LocalDateTime.now(), this.calculateTotalMoney(), this.calculateAverageBalance(), Bukkit.getOnlinePlayers().size(), this.calculateRecentTransactionVolume(), this.calculateMarketActivity(), this.getCurrentCycle(), this.getEconomicHealth(), this.getInflationRate(), this.getVelocityOfMoney()));
    }

    @Override
    public PlayerEconomicProfile getPlayerProfile(UUID playerId) {
        return this.playerProfiles.computeIfAbsent(playerId, PlayerEconomicProfile::new);
    }

    @Override
    public EconomicMemory.EconomicForecast getEconomicForecast() {
        return this.active && this.economicMemory != null ? this.economicMemory.getForecast() : null;
    }

    @Override
    public List<EconomicMemory.EconomicAnomaly> detectAnomalies() {
        if (!this.active || this.economicMemory == null) {
            return List.of();
        }
        return (List)((CompletableFuture)this.getCurrentSnapshot().thenApply(snapshot -> this.economicMemory.detectAnomalies((EconomicSnapshot)snapshot))).join();
    }

    @Override
    public CompletableFuture<Void> forceIntervention(EconomicSnapshot.InterventionType type, double magnitude) {
        if (!this.active) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            this.plugin.getLogger().info("\ud83d\udea8 Admin forced economic intervention: " + String.valueOf((Object)type) + " (magnitude: " + magnitude + ")");
            try {
                this.applyIntervention(type, magnitude, "Admin forced intervention");
                this.lastInterventionDescription = String.valueOf((Object)type) + " (Admin forced, magnitude: " + magnitude + ")";
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to apply forced intervention: " + e.getMessage());
            }
        });
    }

    @Override
    public double getInterventionEffectiveness(EconomicSnapshot.InterventionType type) {
        return this.active && this.economicMemory != null ? this.economicMemory.getInterventionEffectiveness(type) : 0.5;
    }

    @Override
    public void recordPlayerTransaction(UUID playerId, double amount, String type) {
        if (!this.active) {
            return;
        }
        PlayerEconomicProfile profile = this.getPlayerProfile(playerId);
        profile.recordTransaction(amount, type);
        CompletableFuture.runAsync(() -> {
            profile.updateBehaviorMetrics();
            profile.calculateEconomicImpact();
        });
    }

    @Override
    public String getEconomicStatistics() {
        if (!this.active) {
            return "Economic Intelligence System is not active";
        }
        StringBuilder stats = new StringBuilder();
        stats.append("=== Economic Intelligence System Statistics ===\n");
        stats.append("Current Cycle: ").append((Object)this.getCurrentCycle()).append("\n");
        stats.append("Economic Health: ").append(String.format("%.1f%%", this.getEconomicHealth() * 100.0)).append("\n");
        stats.append("Inflation Rate: ").append(String.format("%.2f%%", this.getInflationRate() * 100.0)).append("\n");
        stats.append("Velocity of Money: ").append(String.format("%.2f", this.getVelocityOfMoney())).append("\n");
        stats.append("Tracked Players: ").append(this.playerProfiles.size()).append("\n");
        stats.append("Last Intervention: ").append(this.lastInterventionDescription).append("\n");
        EconomicMemory.EconomicForecast forecast = this.getEconomicForecast();
        if (forecast != null) {
            stats.append("--- Economic Forecast ---\n");
            stats.append("Predicted Health: ").append(String.format("%.1f%%", forecast.getPredictedHealth() * 100.0)).append("\n");
            stats.append("Predicted Inflation: ").append(String.format("%.2f%%", forecast.getPredictedInflation() * 100.0)).append("\n");
            stats.append("Forecast Confidence: ").append(String.format("%.1f%%", forecast.getConfidence() * 100.0)).append("\n");
        }
        stats.append("=== End Statistics ===");
        return stats.toString();
    }

    @Override
    public String getPolicyInfo() {
        return this.intelligenceEngine != null ? this.intelligenceEngine.getPolicyInfo() : "Policy not available";
    }

    @Override
    public boolean setPolicyParam(String name, double value) {
        return this.intelligenceEngine != null && this.intelligenceEngine.setPolicyParam(name, value);
    }

    @Override
    public double[] getMarketFactors() {
        return this.marketManager.getGlobalPriceFactors();
    }

    @Override
    public void reloadPolicy() {
        if (this.intelligenceEngine != null) {
            this.intelligenceEngine.reloadPolicy(this.configManager);
        }
    }

    @Override
    public String runDiagnostics() {
        StringBuilder diagnostics = new StringBuilder();
        diagnostics.append("=== Economic Intelligence System Diagnostics ===\n");
        diagnostics.append("System Status: ").append(this.active ? "ACTIVE" : "INACTIVE").append("\n");
        diagnostics.append("Initialized: ").append(this.initialized).append("\n");
        diagnostics.append("Intelligence Engine: ").append(this.intelligenceEngine != null ? "LOADED" : "NULL").append("\n");
        diagnostics.append("Economic Memory: ").append(this.economicMemory != null ? "LOADED" : "NULL").append("\n");
        diagnostics.append("Player Profiles: ").append(this.playerProfiles.size()).append("\n");
        List<EconomicMemory.EconomicAnomaly> anomalies = this.detectAnomalies();
        diagnostics.append("Detected Anomalies: ").append(anomalies.size()).append("\n");
        for (EconomicMemory.EconomicAnomaly anomaly : anomalies) {
            diagnostics.append("  - ").append((Object)anomaly.type).append(": ").append(anomaly.description).append("\n");
        }
        diagnostics.append("Memory Usage: ").append(this.getMemoryUsage()).append(" MB\n");
        diagnostics.append("=== End Diagnostics ===");
        return diagnostics.toString();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public InflationManager.InflationSystemStatus getSystemStatus() {
        return new InflationManager.InflationSystemStatus(this.active, this.getCurrentCycle(), this.getEconomicHealth(), this.getInflationRate(), this.playerProfiles.size(), this.getDataPointCount(), this.lastInterventionDescription);
    }

    private void applyIntervention(EconomicSnapshot.InterventionType type, double magnitude, String reason) {
        switch (type) {
            case EMERGENCY_STIMULUS: {
                this.applyEmergencyStimulus(magnitude, reason);
                break;
            }
            case MONETARY_EASING: {
                this.applyMonetaryEasing(magnitude, reason);
                break;
            }
            case MONETARY_TIGHTENING: {
                this.applyMonetaryTightening(magnitude, reason);
                break;
            }
            case MARKET_STIMULATION: {
                this.applyMarketStimulation(magnitude, reason);
                break;
            }
            case WEALTH_REDISTRIBUTION: {
                this.applyWealthRedistribution(magnitude, reason);
            }
        }
        if (this.economicMemory != null) {
            EconomicMemory.EconomicIntervention intervention = new EconomicMemory.EconomicIntervention(LocalDateTime.now(), type, magnitude, reason);
            this.economicMemory.recordIntervention(intervention);
        }
    }

    private void applyEmergencyStimulus(double magnitude, String reason) {
        this.plugin.getLogger().info("\ud83d\udc89 Applying Emergency Economic Stimulus (magnitude: " + magnitude + ")");
        double totalStimulus = magnitude * (double)Bukkit.getOnlinePlayers().size() * 1000.0;
        Bukkit.getOnlinePlayers().forEach(player -> {
            double playerStimulus = totalStimulus / (double)Bukkit.getOnlinePlayers().size();
            this.economyManager.addMoney(player.getUniqueId(), BigDecimal.valueOf(playerStimulus), "Emergency Economic Stimulus - " + reason);
        });
        this.plugin.getLogger().info("Emergency stimulus of $" + String.format("%.2f", totalStimulus) + " distributed");
    }

    private void applyMonetaryEasing(double magnitude, String reason) {
        this.plugin.getLogger().info("\ud83d\udcc9 Applying Monetary Easing (magnitude: " + magnitude + ")");
    }

    private void applyMonetaryTightening(double magnitude, String reason) {
        this.plugin.getLogger().info("\ud83d\udcc8 Applying Monetary Tightening (magnitude: " + magnitude + ")");
    }

    private void applyMarketStimulation(double magnitude, String reason) {
        this.plugin.getLogger().info("\ud83c\udfea Applying Market Stimulation (magnitude: " + magnitude + ")");
    }

    private void applyWealthRedistribution(double magnitude, String reason) {
        this.plugin.getLogger().info("\u2696\ufe0f Applying Wealth Redistribution (magnitude: " + magnitude + ")");
    }

    private void loadPlayerProfiles() {
        this.plugin.getLogger().info("Loading player economic profiles...");
    }

    private void savePlayerProfiles() {
        this.plugin.getLogger().info("Saving player economic profiles...");
    }

    private void logSystemStatus() {
        this.plugin.getLogger().info("\ud83d\udcca Economic System Status:");
        this.plugin.getLogger().info("  Cycle: " + String.valueOf((Object)this.getCurrentCycle()));
        this.plugin.getLogger().info("  Health: " + String.format("%.1f%%", this.getEconomicHealth() * 100.0));
        this.plugin.getLogger().info("  Inflation: " + String.format("%.2f%%", this.getInflationRate() * 100.0));
        this.plugin.getLogger().info("  Players Tracked: " + this.playerProfiles.size());
    }

    private double calculateTotalMoney() {
        return (double)Bukkit.getOnlinePlayers().size() * 50000.0;
    }

    private double calculateAverageBalance() {
        return 25000.0;
    }

    private double calculateRecentTransactionVolume() {
        return 100000.0;
    }

    private double calculateMarketActivity() {
        return 0.6;
    }

    private long getDataPointCount() {
        return this.economicMemory != null ? 1000L : 0L;
    }

    private long getMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L;
    }
}

