/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.integrations.jobs;

import java.util.List;
import java.util.Map;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.modules.inflation.InflationManager;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class JobsIntegration
implements Listener {
    private final EcoXpertPlugin plugin;

    public JobsIntegration(EcoXpertPlugin plugin) {
        this.plugin = plugin;
    }

    public void registerIfPresent() {
        try {
            if (Bukkit.getPluginManager().getPlugin("Jobs") == null && Bukkit.getPluginManager().getPlugin("JobsReborn") == null) {
                return;
            }
            Class.forName("com.gamingmesh.jobs.api.JobsPaymentEvent");
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            this.plugin.getLogger().info("Jobs Reborn detected: dynamic payout adjustment enabled");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @EventHandler
    public void onJobsPayment(Event raw) {
        try {
            if (!"com.gamingmesh.jobs.api.JobsPaymentEvent".equals(raw.getClass().getName())) {
                return;
            }
            Event event = raw;
            Player player = (Player)event.getClass().getMethod("getPlayer", new Class[0]).invoke((Object)event, new Object[0]);
            if (player == null) {
                return;
            }
            double amount = 0.0;
            try {
                amount = (Double)event.getClass().getMethod("getAmount", new Class[0]).invoke((Object)event, new Object[0]);
            }
            catch (NoSuchMethodException ns1) {
                try {
                    amount = (Double)event.getClass().getMethod("getPayment", new Class[0]).invoke((Object)event, new Object[0]);
                }
                catch (NoSuchMethodException ns2) {
                    return;
                }
            }
            double factor = this.computeJobsFactor(player);
            if (Math.abs(factor - 1.0) < 1.0E-6) {
                return;
            }
            double newAmount = Math.max(0.0, amount * factor);
            try {
                event.getClass().getMethod("setAmount", Double.TYPE).invoke((Object)event, newAmount);
            }
            catch (NoSuchMethodException ns1) {
                try {
                    event.getClass().getMethod("setPayment", Double.TYPE).invoke((Object)event, newAmount);
                }
                catch (NoSuchMethodException ns2) {
                    return;
                }
            }
            if (this.plugin.getConfig().getBoolean("plugin.debug", false)) {
                this.plugin.getLogger().info(String.format("Jobs payout adjusted for %s: %.2f -> %.2f (x%.3f)", player.getName(), amount, newAmount, factor));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private double computeJobsFactor(Player player) {
        try {
            FileConfiguration cfg = this.plugin.getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("integrations");
            ConfigurationSection sec = cfg.getConfigurationSection("jobs.dynamic");
            if (sec == null || !sec.getBoolean("enabled", true)) {
                return 1.0;
            }
            InflationManager infl = this.plugin.getServiceRegistry().getInstance(InflationManager.class);
            double inflRate = infl != null ? infl.getInflationRate() : 0.0;
            List thresholds = sec.getList("inflation.thresholds");
            double factor = 1.0;
            if (thresholds != null) {
                for (Object o : thresholds) {
                    double fac;
                    if (!(o instanceof Map)) continue;
                    Map map = (Map)o;
                    Object r = map.get("rate");
                    Object f = map.get("factor");
                    double rate = r instanceof Number ? ((Number)r).doubleValue() : Double.parseDouble(String.valueOf(r));
                    double d = fac = f instanceof Number ? ((Number)f).doubleValue() : Double.parseDouble(String.valueOf(f));
                    if (!(inflRate >= rate)) continue;
                    factor = Math.min(factor, fac);
                }
            }
            if (factor < 0.5) {
                factor = 0.5;
            }
            if (factor > 1.1) {
                factor = 1.1;
            }
            return factor;
        }
        catch (Exception e) {
            return 1.0;
        }
    }
}

