/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.loans;

import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.data.DataManager;
import me.koyere.ecoxpert.core.data.QueryResult;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class LoanNotificationListener
implements Listener {
    private final EcoXpertPlugin plugin;
    private final DataManager dataManager;
    private final TranslationManager translationManager;

    public LoanNotificationListener(EcoXpertPlugin plugin, DataManager dataManager, TranslationManager translationManager) {
        this.plugin = plugin;
        this.dataManager = dataManager;
        this.translationManager = translationManager;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (QueryResult qr = this.dataManager.executeQuery("SELECT COUNT(*) as c FROM ecoxpert_loan_schedules s JOIN ecoxpert_loans l ON l.id = s.loan_id WHERE l.player_uuid = ? AND s.status = 'LATE'", p.getUniqueId().toString()).join();){
                if (qr.next()) {
                    int late;
                    Integer c = qr.getInt("c");
                    int n = c != null ? c : (late = qr.getLong("c") != null ? qr.getLong("c").intValue() : 0);
                    if (late > 0) {
                        p.sendMessage(this.translationManager.getMessage("prefix", new Object[0]) + this.translationManager.getPlayerMessage(p, "loans.overdue-summary", late));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

