/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.loans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.gui.BaseGUI;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.loans.Loan;
import me.koyere.ecoxpert.modules.loans.LoanManager;
import me.koyere.ecoxpert.modules.loans.LoanOffer;
import me.koyere.ecoxpert.modules.loans.LoanPayment;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class LoansGUI
extends BaseGUI {
    private final LoanManager loanManager;
    private final EconomyManager economyManager;
    private final TranslationManager tm;
    private final Map<UUID, LoanOffer> pendingOffer = new ConcurrentHashMap<UUID, LoanOffer>();
    private final Map<UUID, Integer> schedulePage = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, List<LoanPayment>> scheduleCache = new ConcurrentHashMap<UUID, List<LoanPayment>>();

    public LoansGUI(EcoXpertPlugin plugin, LoanManager loanManager, EconomyManager economyManager, TranslationManager tm) {
        super(plugin);
        this.loanManager = loanManager;
        this.economyManager = economyManager;
        this.tm = tm;
    }

    @Override
    protected Inventory create(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.tm.getMessage("loans.gui.title", new Object[0]));
        inv.setItem(10, this.button(Material.EMERALD, this.tm.getMessage("loans.gui.offer", "+1000", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("loans.gui.offer-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.offer-lore2", new Object[0])}));
        inv.setItem(11, this.button(Material.EMERALD, this.tm.getMessage("loans.gui.offer", "+5000", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("loans.gui.offer-large-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.offer-large-lore2", new Object[0])}));
        inv.setItem(13, this.button(Material.PAPER, this.tm.getMessage("loans.gui.status", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("loans.gui.status-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.status-lore2", new Object[0])}));
        inv.setItem(15, this.button(Material.GOLD_INGOT, this.tm.getMessage("loans.gui.pay", "500", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("loans.gui.pay-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.pay-lore2", new Object[0])}));
        inv.setItem(16, this.button(Material.GOLD_INGOT, this.tm.getMessage("loans.gui.pay", "1000", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("loans.gui.pay-fast-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.pay-fast-lore2", new Object[0])}));
        inv.setItem(22, this.button(Material.BOOK, this.tm.getMessage("loans.gui.schedule.button", new Object[0]), new String[]{"\u00a77" + this.tm.getMessage("loans.gui.schedule-lore1", new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.schedule-lore2", new Object[0])}));
        return inv;
    }

    private ItemStack button(Material mat, String name) {
        return this.button(mat, name, null);
    }

    private ItemStack button(Material mat, String name, String[] lore) {
        ItemStack it = new ItemStack(mat);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName("\u00a7e" + name);
        if (lore != null) {
            meta.setLore(Arrays.asList(lore));
        }
        it.setItemMeta(meta);
        return it;
    }

    @Override
    protected void onClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        ItemStack it = e.getCurrentItem();
        if (it == null || !it.hasItemMeta() || !it.getItemMeta().hasDisplayName()) {
            return;
        }
        String name = it.getItemMeta().getDisplayName();
        if (name.contains("+1000")) {
            this.openOfferPreview(p, new BigDecimal("1000"));
        } else if (name.contains("+5000")) {
            this.openOfferPreview(p, new BigDecimal("5000"));
        } else if (name.contains(this.tm.getMessage("loans.gui.status", new Object[0]))) {
            this.loanManager.getActiveLoan(p.getUniqueId()).thenAccept(opt -> {
                if (opt.isEmpty()) {
                    p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("loans.no-active-loans", new Object[0]));
                } else {
                    Loan loan = (Loan)opt.get();
                    p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("loans.status", this.economyManager.formatMoney(loan.getOutstanding()), this.economyManager.formatMoney(loan.getPrincipal()), String.valueOf(loan.getInterestRate().multiply(new BigDecimal("100")).setScale(1)) + "%"));
                }
            });
        } else if (name.contains("500")) {
            this.loanManager.payLoan(p.getUniqueId(), new BigDecimal("500")).thenAccept(ok -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + (ok != false ? this.tm.getMessage("loans.payment-made", this.economyManager.formatMoney(new BigDecimal("500")), new Object[0]) : this.tm.getMessage("loans.loan-denied", "", new Object[0]))));
        } else if (name.contains("1000")) {
            this.loanManager.payLoan(p.getUniqueId(), new BigDecimal("1000")).thenAccept(ok -> p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + (ok != false ? this.tm.getMessage("loans.payment-made", this.economyManager.formatMoney(new BigDecimal("1000")), new Object[0]) : this.tm.getMessage("loans.loan-denied", "", new Object[0]))));
        } else if (name.contains(this.tm.getMessage("loans.gui.schedule.button", new Object[0]))) {
            this.openScheduleGUI(p, 0);
        } else if (e.getView().getTitle().equals(this.tm.getMessage("loans.gui.offer-preview.title", new Object[0]))) {
            e.setCancelled(true);
            if (name.contains(this.tm.getMessage("loans.gui.confirm", new Object[0]))) {
                LoanOffer offer = this.pendingOffer.get(p.getUniqueId());
                if (offer != null && offer.approved()) {
                    this.loanManager.requestLoanSmart(p.getUniqueId(), offer.amount()).thenAccept(ok -> {
                        p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + (ok != false ? this.tm.getMessage("loans.loan-approved", this.economyManager.formatMoney(offer.amount()), new Object[0]) : this.tm.getMessage("loans.loan-denied", "", new Object[0])));
                        this.pendingOffer.remove(p.getUniqueId());
                        p.closeInventory();
                    });
                } else {
                    p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + this.tm.getMessage("loans.loan-denied", "", new Object[0]));
                    p.closeInventory();
                }
            } else if (name.contains(this.tm.getMessage("loans.gui.cancel", new Object[0]))) {
                this.pendingOffer.remove(p.getUniqueId());
                p.closeInventory();
            }
        } else if (e.getView().getTitle().equals(this.tm.getMessage("loans.gui.schedule.title", new Object[0]))) {
            e.setCancelled(true);
            if (it.getType() == Material.ARROW) {
                if (name.contains("Prev")) {
                    int page = this.schedulePage.getOrDefault(p.getUniqueId(), 0);
                    if (page > 0) {
                        this.openScheduleGUI(p, page - 1);
                    }
                } else {
                    int page = this.schedulePage.getOrDefault(p.getUniqueId(), 0);
                    this.openScheduleGUI(p, page + 1);
                }
            }
        }
    }

    private void openOfferPreview(Player p, BigDecimal amount) {
        this.loanManager.getOffer(p.getUniqueId(), amount).thenAccept(offer -> {
            this.pendingOffer.put(p.getUniqueId(), (LoanOffer)offer);
            Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.tm.getMessage("loans.gui.offer-preview.title", new Object[0]));
            ItemStack info = new ItemStack(Material.BOOK);
            ItemMeta meta = info.getItemMeta();
            meta.setDisplayName("\u00a7e" + this.tm.getMessage("loans.offer.header", new Object[0]));
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + this.tm.getMessage("loans.offer.details", this.economyManager.formatMoney(offer.amount()), String.valueOf(offer.interestRate().multiply(new BigDecimal("100")).setScale(2)) + "%", offer.termDays(), offer.score()));
            lore.add(" ");
            lore.add(offer.approved() ? "\u00a7a" + this.tm.getMessage("loans.gui.offer-preview.approved", new Object[0]) : "\u00a7c" + this.tm.getMessage("loans.gui.offer-preview.denied", offer.reason(), new Object[0]));
            meta.setLore(lore);
            info.setItemMeta(meta);
            inv.setItem(11, info);
            if (offer.approved()) {
                inv.setItem(15, this.button(Material.LIME_WOOL, this.tm.getMessage("loans.gui.confirm", new Object[0])));
            }
            inv.setItem(22, this.button(Material.BARRIER, this.tm.getMessage("loans.gui.cancel", new Object[0])));
            this.inventory = inv;
            p.openInventory(inv);
        });
    }

    private void openScheduleGUI(Player p, int page) {
        this.loanManager.getSchedule(p.getUniqueId()).thenAccept(list -> {
            this.scheduleCache.put(p.getUniqueId(), (List<LoanPayment>)list);
            this.schedulePage.put(p.getUniqueId(), page);
            int perPage = 45;
            int totalPages = Math.max(1, (int)Math.ceil((double)list.size() / (double)perPage));
            int clamped = Math.max(0, Math.min(page, totalPages - 1));
            Inventory inv = Bukkit.createInventory(null, (int)54, (String)this.tm.getMessage("loans.gui.schedule.title", new Object[0]));
            int start = clamped * perPage;
            int end = Math.min(start + perPage, list.size());
            int slot = 0;
            for (int i = start; i < end; ++i) {
                LoanPayment s = (LoanPayment)list.get(i);
                ItemStack paper = new ItemStack(Material.PAPER);
                ItemMeta meta = paper.getItemMeta();
                meta.setDisplayName("\u00a7e#" + s.installmentNo() + " - " + s.status());
                meta.setLore(Arrays.asList("\u00a77" + this.tm.getMessage("loans.gui.schedule-item.due", s.dueDate()), "\u00a77" + this.tm.getMessage("loans.gui.schedule-item.amount", this.economyManager.formatMoney(s.amountDue()), new Object[0]), "\u00a77" + this.tm.getMessage("loans.gui.schedule-item.paid", this.economyManager.formatMoney(s.paidAmount()), new Object[0])));
                paper.setItemMeta(meta);
                inv.setItem(slot++, paper);
            }
            ItemStack prev = new ItemStack(Material.ARROW);
            ItemMeta pm = prev.getItemMeta();
            pm.setDisplayName("\u00a7a" + this.tm.getMessage("loans.gui.schedule-item.prev", new Object[0]));
            prev.setItemMeta(pm);
            ItemStack next = new ItemStack(Material.ARROW);
            ItemMeta nm = next.getItemMeta();
            nm.setDisplayName("\u00a7a" + this.tm.getMessage("loans.gui.schedule-item.next", new Object[0]));
            next.setItemMeta(nm);
            inv.setItem(45, prev);
            inv.setItem(53, next);
            this.inventory = inv;
            p.openInventory(inv);
        });
    }
}

