/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;
import org.bukkit.Material;

public final class MarketItem {
    private final Material material;
    private final BigDecimal basePrice;
    private final BigDecimal currentBuyPrice;
    private final BigDecimal currentSellPrice;
    private final boolean buyable;
    private final boolean sellable;
    private final int totalSold;
    private final int totalBought;
    private final LocalDateTime lastPriceUpdate;
    private final BigDecimal priceVolatility;

    public MarketItem(Material material, BigDecimal basePrice, BigDecimal currentBuyPrice, BigDecimal currentSellPrice, boolean buyable, boolean sellable, int totalSold, int totalBought, LocalDateTime lastPriceUpdate, BigDecimal priceVolatility) {
        this.material = Objects.requireNonNull(material, "Material cannot be null");
        this.basePrice = Objects.requireNonNull(basePrice, "Base price cannot be null");
        this.currentBuyPrice = Objects.requireNonNull(currentBuyPrice, "Current buy price cannot be null");
        this.currentSellPrice = Objects.requireNonNull(currentSellPrice, "Current sell price cannot be null");
        this.buyable = buyable;
        this.sellable = sellable;
        this.totalSold = Math.max(0, totalSold);
        this.totalBought = Math.max(0, totalBought);
        this.lastPriceUpdate = lastPriceUpdate;
        this.priceVolatility = Objects.requireNonNull(priceVolatility, "Price volatility cannot be null");
    }

    public static Builder builder(Material material, BigDecimal basePrice) {
        return new Builder(material, basePrice);
    }

    public Material getMaterial() {
        return this.material;
    }

    public BigDecimal getBasePrice() {
        return this.basePrice;
    }

    public BigDecimal getCurrentBuyPrice() {
        return this.currentBuyPrice;
    }

    public BigDecimal getCurrentSellPrice() {
        return this.currentSellPrice;
    }

    public boolean isBuyable() {
        return this.buyable;
    }

    public boolean isSellable() {
        return this.sellable;
    }

    public int getTotalSold() {
        return this.totalSold;
    }

    public int getTotalBought() {
        return this.totalBought;
    }

    public LocalDateTime getLastPriceUpdate() {
        return this.lastPriceUpdate;
    }

    public BigDecimal getPriceVolatility() {
        return this.priceVolatility;
    }

    public boolean isActivelyTraded() {
        return this.buyable || this.sellable;
    }

    public BigDecimal getPriceDifferenceFromBase() {
        return this.currentBuyPrice.subtract(this.basePrice);
    }

    public BigDecimal getPriceChangePercentage() {
        if (this.basePrice.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        return this.getPriceDifferenceFromBase().divide(this.basePrice, 4, 4).multiply(BigDecimal.valueOf(100L));
    }

    public int getTotalVolume() {
        return this.totalSold + this.totalBought;
    }

    public MarketItem withPrices(BigDecimal newBuyPrice, BigDecimal newSellPrice) {
        return new MarketItem(this.material, this.basePrice, newBuyPrice, newSellPrice, this.buyable, this.sellable, this.totalSold, this.totalBought, LocalDateTime.now(), this.priceVolatility);
    }

    public MarketItem withUpdatedStats(int additionalSold, int additionalBought) {
        return new MarketItem(this.material, this.basePrice, this.currentBuyPrice, this.currentSellPrice, this.buyable, this.sellable, this.totalSold + additionalSold, this.totalBought + additionalBought, this.lastPriceUpdate, this.priceVolatility);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MarketItem that = (MarketItem)obj;
        return this.material == that.material;
    }

    public int hashCode() {
        return Objects.hash(this.material);
    }

    public String toString() {
        return String.format("MarketItem{material=%s, basePrice=%s, buyPrice=%s, sellPrice=%s, buyable=%s, sellable=%s}", this.material, this.basePrice, this.currentBuyPrice, this.currentSellPrice, this.buyable, this.sellable);
    }

    public static class Builder {
        private final Material material;
        private final BigDecimal basePrice;
        private BigDecimal currentBuyPrice;
        private BigDecimal currentSellPrice;
        private boolean buyable = true;
        private boolean sellable = true;
        private int totalSold = 0;
        private int totalBought = 0;
        private LocalDateTime lastPriceUpdate = LocalDateTime.now();
        private BigDecimal priceVolatility = BigDecimal.valueOf(0.1);

        private Builder(Material material, BigDecimal basePrice) {
            this.material = material;
            this.basePrice = basePrice;
            this.currentBuyPrice = basePrice;
            this.currentSellPrice = basePrice.multiply(BigDecimal.valueOf(0.8));
        }

        public Builder currentBuyPrice(BigDecimal price) {
            this.currentBuyPrice = price;
            return this;
        }

        public Builder currentSellPrice(BigDecimal price) {
            this.currentSellPrice = price;
            return this;
        }

        public Builder buyable(boolean buyable) {
            this.buyable = buyable;
            return this;
        }

        public Builder sellable(boolean sellable) {
            this.sellable = sellable;
            return this;
        }

        public Builder totalSold(int totalSold) {
            this.totalSold = totalSold;
            return this;
        }

        public Builder totalBought(int totalBought) {
            this.totalBought = totalBought;
            return this;
        }

        public Builder lastPriceUpdate(LocalDateTime lastPriceUpdate) {
            this.lastPriceUpdate = lastPriceUpdate;
            return this;
        }

        public Builder priceVolatility(BigDecimal volatility) {
            this.priceVolatility = volatility;
            return this;
        }

        public MarketItem build() {
            return new MarketItem(this.material, this.basePrice, this.currentBuyPrice, this.currentSellPrice, this.buyable, this.sellable, this.totalSold, this.totalBought, this.lastPriceUpdate, this.priceVolatility);
        }
    }
}

