/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.koyere.ecoxpert.modules.market.MarketItem;
import me.koyere.ecoxpert.modules.market.MarketItemStats;
import me.koyere.ecoxpert.modules.market.MarketPriceHistory;
import me.koyere.ecoxpert.modules.market.MarketStatistics;
import me.koyere.ecoxpert.modules.market.MarketTransaction;
import me.koyere.ecoxpert.modules.market.MarketTransactionResult;
import me.koyere.ecoxpert.modules.market.MarketTrend;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public interface MarketManager {
    public void initialize();

    public void shutdown();

    public boolean isMarketOpen();

    public void setMarketOpen(boolean var1);

    public CompletableFuture<List<MarketItem>> getAllItems();

    public CompletableFuture<Optional<MarketItem>> getItem(Material var1);

    public CompletableFuture<Void> addItem(Material var1, BigDecimal var2, boolean var3, boolean var4);

    public CompletableFuture<Void> removeItem(Material var1);

    public CompletableFuture<BigDecimal> getBuyPrice(Material var1);

    public CompletableFuture<BigDecimal> getSellPrice(Material var1);

    public CompletableFuture<List<MarketPriceHistory>> getPriceHistory(Material var1, int var2);

    public CompletableFuture<Void> updatePrices();

    public CompletableFuture<MarketTransactionResult> buyItem(Player var1, Material var2, int var3);

    public CompletableFuture<MarketTransactionResult> sellItem(Player var1, Material var2, int var3);

    public CompletableFuture<List<MarketTransaction>> getPlayerTransactions(UUID var1, int var2);

    public CompletableFuture<List<MarketTransaction>> getRecentTransactions(int var1);

    public CompletableFuture<MarketStatistics> getMarketStatistics();

    public CompletableFuture<List<MarketItemStats>> getTopTradedItems(int var1);

    public CompletableFuture<MarketTrend> getItemTrend(Material var1);

    public boolean canAfford(Player var1, BigDecimal var2);

    public boolean hasItems(Player var1, Material var2, int var3);

    public int countItems(Player var1, Material var2);

    public boolean addItemsToInventory(Player var1, ItemStack var2);

    public boolean removeItemsFromInventory(Player var1, Material var2, int var3);

    public void setGlobalPriceFactors(double var1, double var3);

    public double[] getGlobalPriceFactors();

    public void applyTemporaryItemFactors(Map<Material, double[]> var1, int var2);
}

