/*
 * Decompiled with CFR 0.152.
 */
package me.koyere.ecoxpert.modules.market.orders;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import me.koyere.ecoxpert.EcoXpertPlugin;
import me.koyere.ecoxpert.core.config.ConfigManager;
import me.koyere.ecoxpert.core.translation.TranslationManager;
import me.koyere.ecoxpert.economy.EconomyManager;
import me.koyere.ecoxpert.modules.market.orders.MarketOrder;
import me.koyere.ecoxpert.modules.market.orders.MarketOrderService;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MarketOrdersGUI
implements Listener {
    private final MarketOrderService orderService;
    private final TranslationManager tm;
    private final Logger logger;
    private static final int INVENTORY_SIZE = 54;
    private static final int ITEMS_PER_PAGE = 45;
    private static final int SLOT_PREV = 45;
    private static final int SLOT_CLEAR = 47;
    private static final int SLOT_FILTER = 46;
    private static final int SLOT_SORT = 48;
    private static final int SLOT_INFO = 49;
    private static final int SLOT_CLOSE = 50;
    private static final int SLOT_NEXT = 53;
    private final Map<UUID, OrdersView> open = new ConcurrentHashMap<UUID, OrdersView>();
    private final Map<UUID, SelectionView> selecting = new ConcurrentHashMap<UUID, SelectionView>();

    public MarketOrdersGUI(MarketOrderService orderService, TranslationManager tm, Logger logger) {
        this.orderService = orderService;
        this.tm = tm;
        this.logger = logger;
    }

    public void open(Player player, Material filter) {
        this.orderService.listOpenOrders(filter).thenAccept(list -> Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), () -> {
            OrdersView view = new OrdersView(player.getUniqueId(), (List<MarketOrder>)list, 0, filter, SortMode.PRICE_ASC);
            view.orders = this.applySort(view.orders, view.sortMode);
            this.open.put(player.getUniqueId(), view);
            player.openInventory(this.build(view));
        }));
    }

    private Inventory build(OrdersView view) {
        ItemStack close;
        ItemMeta cm;
        ArrayList<CallSite> lore;
        ItemMeta im;
        String title = this.tm.getMessage("market.gui.orders.title", new Object[0]);
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)title);
        int start = view.page * 45;
        int end = Math.min(start + 45, view.orders.size());
        int totalPages = (int)Math.ceil((double)view.orders.size() / 45.0);
        int slot = 0;
        for (int i = start; i < end; ++i) {
            MarketOrder o = view.orders.get(i);
            inv.setItem(slot++, this.renderOrderItem(o));
        }
        if (view.page > 0) {
            ItemStack it = new ItemStack(Material.ARROW);
            im = it.getItemMeta();
            if (im != null) {
                im.setDisplayName("\u00a7a" + this.tm.getMessage("market.gui.prev-page", new Object[0]));
                lore = new ArrayList<CallSite>();
                lore.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.info.page", view.page + 1, Math.max(1, totalPages)))));
                im.setLore(lore);
                it.setItemMeta(im);
            }
            inv.setItem(45, it);
        }
        if (view.page < totalPages - 1) {
            ItemStack it = new ItemStack(Material.ARROW);
            im = it.getItemMeta();
            if (im != null) {
                im.setDisplayName("\u00a7a" + this.tm.getMessage("market.gui.next-page", new Object[0]));
                lore = new ArrayList();
                lore.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.info.page", view.page + 1, Math.max(1, totalPages)))));
                im.setLore(lore);
                it.setItemMeta(im);
            }
            inv.setItem(53, it);
        }
        if ((cm = (close = new ItemStack(Material.BARRIER)).getItemMeta()) != null) {
            cm.setDisplayName("\u00a7c" + this.tm.getMessage("market.gui.close", new Object[0]));
            close.setItemMeta(cm);
        }
        inv.setItem(50, close);
        ItemStack info = new ItemStack(Material.BOOK);
        ItemMeta im2 = info.getItemMeta();
        if (im2 != null) {
            im2.setDisplayName("\u00a76" + this.tm.getMessage("market.gui.orders.info.title", new Object[0]));
            ArrayList<Object> lore2 = new ArrayList<Object>();
            lore2.add("\u00a77" + this.tm.getMessage("market.gui.orders.info.count", view.orders.size()));
            lore2.add("\u00a77" + this.tm.getMessage("market.gui.orders.info.page", view.page + 1, Math.max(1, totalPages)));
            String f = view.filter != null ? view.filter.name() : "ALL";
            lore2.add("\u00a77" + this.tm.getMessage("market.gui.orders.info.filter", f, new Object[0]));
            lore2.add("");
            lore2.add("\u00a7e" + this.tm.getMessage("market.gui.orders.info.help1", new Object[0]));
            lore2.add("\u00a7e" + this.tm.getMessage("market.gui.orders.info.help2", new Object[0]));
            im2.setLore(lore2);
            info.setItemMeta(im2);
        }
        inv.setItem(49, info);
        ItemStack filt = new ItemStack(view.filter != null ? view.filter : Material.NAME_TAG);
        ItemMeta fm = filt.getItemMeta();
        if (fm != null) {
            fm.setDisplayName("\u00a7b" + this.tm.getMessage("market.gui.orders.filter-label", view.filter != null ? view.filter.name() : "ALL", new Object[0]));
            ArrayList<CallSite> lore3 = new ArrayList<CallSite>();
            lore3.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.set-filter-help", new Object[0]))));
            fm.setLore(lore3);
            filt.setItemMeta(fm);
        }
        inv.setItem(46, filt);
        ItemStack sort = new ItemStack(Material.HOPPER);
        ItemMeta sm = sort.getItemMeta();
        if (sm != null) {
            sm.setDisplayName("\u00a7b" + this.tm.getMessage("market.gui.orders.sort-title", new Object[0]));
            ArrayList<CallSite> lore4 = new ArrayList<CallSite>();
            lore4.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.sort-label", this.sortLabel(view.sortMode), new Object[0]))));
            lore4.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.sort-help", new Object[0]))));
            sm.setLore(lore4);
            sort.setItemMeta(sm);
        }
        inv.setItem(48, sort);
        ItemStack clear = new ItemStack(Material.BARRIER);
        ItemMeta clm = clear.getItemMeta();
        if (clm != null) {
            clm.setDisplayName("\u00a7c" + this.tm.getMessage("market.gui.orders.clear-filter", new Object[0]));
            ArrayList<CallSite> lore5 = new ArrayList<CallSite>();
            lore5.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.clear-filter-help", new Object[0]))));
            clm.setLore(lore5);
            clear.setItemMeta(clm);
        }
        inv.setItem(47, clear);
        if (view.orders.isEmpty()) {
            ItemStack empty = new ItemStack(Material.PAPER);
            ItemMeta em = empty.getItemMeta();
            if (em != null) {
                em.setDisplayName("\u00a77" + this.tm.getMessage("market.orders.none", new Object[0]));
                empty.setItemMeta(em);
            }
            inv.setItem(22, empty);
        }
        return inv;
    }

    private ItemStack renderOrderItem(MarketOrder o) {
        ItemStack it = new ItemStack(o.getMaterial());
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            String title = "\u00a7e" + this.tm.getMessage("market.gui.orders.item.header", o.getId());
            im.setDisplayName(title);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a77" + this.tm.getMessage("market.gui.orders.item.material", o.getMaterial().name(), new Object[0]));
            lore.add("\u00a77" + this.tm.getMessage("market.gui.orders.item.price", this.format(o.getUnitPrice()), new Object[0]));
            lore.add("\u00a77" + this.tm.getMessage("market.gui.orders.item.remaining", o.getRemainingQuantity()));
            String expires = o.getExpiresAt() == null ? "\u2014" : this.humanExpire(o.getExpiresAt());
            lore.add("\u00a77" + this.tm.getMessage("market.gui.orders.item.expires", expires, new Object[0]));
            String sellerName = this.shortSeller(o.getSeller());
            lore.add("\u00a77" + this.tm.getMessage("market.gui.orders.item.seller", sellerName, new Object[0]));
            lore.add("");
            lore.add("\u00a7e" + this.tm.getMessage("market.gui.orders.item.help1", new Object[0]));
            lore.add("\u00a7e" + this.tm.getMessage("market.gui.orders.item.help2", new Object[0]));
            lore.add("\u00a7e" + this.tm.getMessage("market.gui.orders.item.help3", new Object[0]));
            im.setLore(lore);
            it.setItemMeta(im);
        }
        return it;
    }

    private String format(BigDecimal amount) {
        EconomyManager eco = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(EconomyManager.class);
        return eco.formatMoney(amount);
    }

    private String humanExpire(LocalDateTime t) {
        long mins = Duration.between(LocalDateTime.now(), t).toMinutes();
        if (mins <= 0L) {
            return this.tm.getMessage("market.gui.orders.item.expired", new Object[0]);
        }
        long h = mins / 60L;
        long m = mins % 60L;
        if (h > 0L) {
            return this.tm.getMessage("market.gui.orders.item.expires_in_hm", h, m);
        }
        return this.tm.getMessage("market.gui.orders.item.expires_in_m", m);
    }

    private String shortSeller(UUID uuid) {
        try {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)uuid);
            if (op != null && op.getName() != null) {
                return op.getName();
            }
        }
        catch (Exception op) {
            // empty catch block
        }
        String s = uuid.toString();
        return s.substring(0, 8);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        int index;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        OrdersView view = this.open.get(p.getUniqueId());
        if (view == null) {
            return;
        }
        if (!e.getView().getTitle().equals(this.tm.getMessage("market.gui.orders.title", new Object[0]))) {
            return;
        }
        e.setCancelled(true);
        int slot = e.getRawSlot();
        if (slot == 50) {
            p.closeInventory();
            return;
        }
        if (slot == 45 && view.page > 0) {
            --view.page;
            this.refresh(p, view);
            return;
        }
        int totalPages = (int)Math.ceil((double)view.orders.size() / 45.0);
        if (slot == 53 && view.page < totalPages - 1) {
            ++view.page;
            this.refresh(p, view);
            return;
        }
        if (slot == 46) {
            Material held = p.getInventory().getItemInMainHand() != null ? p.getInventory().getItemInMainHand().getType() : Material.AIR;
            Material newFilter = held != null && held != Material.AIR ? held : null;
            this.orderService.listOpenOrders(newFilter).thenAccept(list -> Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), () -> {
                OrdersView nv = new OrdersView(p.getUniqueId(), (List<MarketOrder>)list, 0, newFilter, view.sortMode);
                nv.orders = this.applySort(nv.orders, nv.sortMode);
                this.open.put(p.getUniqueId(), nv);
                this.refresh(p, nv);
            }));
            return;
        }
        if (slot == 48) {
            SortMode next;
            view.sortMode = next = this.nextSort(view.sortMode);
            view.orders = this.applySort(view.orders, view.sortMode);
            this.refresh(p, view);
            return;
        }
        if (slot == 47) {
            this.orderService.listOpenOrders(null).thenAccept(list -> Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), () -> {
                OrdersView nv = new OrdersView(p.getUniqueId(), (List<MarketOrder>)list, 0, null, view.sortMode);
                nv.orders = this.applySort(nv.orders, nv.sortMode);
                this.open.put(p.getUniqueId(), nv);
                this.refresh(p, nv);
            }));
            return;
        }
        if (slot < 45 && (index = view.page * 45 + slot) >= 0 && index < view.orders.size()) {
            MarketOrder o = view.orders.get(index);
            int qty = 1;
            if (e.isRightClick()) {
                qty = Math.min(16, o.getRemainingQuantity());
            }
            if (e.isShiftClick()) {
                qty = o.getRemainingQuantity();
            }
            int finalQty = Math.max(1, Math.min(qty, o.getRemainingQuantity()));
            this.openSelect(p, view, o, finalQty);
        }
    }

    private void refresh(Player p, OrdersView view) {
        p.getOpenInventory().getTopInventory().setContents(this.build(view).getContents());
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        HumanEntity humanEntity = e.getPlayer();
        if (humanEntity instanceof Player) {
            Player p = (Player)humanEntity;
            if (this.tm.getMessage("market.gui.orders.title", new Object[0]).equals(e.getView().getTitle())) {
                this.open.remove(p.getUniqueId());
            }
        }
    }

    private List<MarketOrder> applySort(List<MarketOrder> orders, SortMode mode) {
        ArrayList<MarketOrder> list = new ArrayList<MarketOrder>(orders);
        switch (mode) {
            case PRICE_ASC: {
                list.sort(Comparator.comparing(MarketOrder::getUnitPrice));
                break;
            }
            case PRICE_DESC: {
                list.sort(Comparator.comparing(MarketOrder::getUnitPrice).reversed());
                break;
            }
            case REMAIN_ASC: {
                list.sort(Comparator.comparingInt(MarketOrder::getRemainingQuantity));
                break;
            }
            case REMAIN_DESC: {
                list.sort(Comparator.comparingInt(MarketOrder::getRemainingQuantity).reversed());
                break;
            }
            case EXPIRE_ASC: {
                list.sort(Comparator.comparing(o -> o.getExpiresAt() == null ? LocalDateTime.MAX : o.getExpiresAt()));
                break;
            }
            case EXPIRE_DESC: {
                list.sort(Comparator.comparing(o -> o.getExpiresAt() == null ? LocalDateTime.MAX : o.getExpiresAt()).reversed());
            }
        }
        return list;
    }

    private SortMode nextSort(SortMode m) {
        return switch (m) {
            default -> throw new IncompatibleClassChangeError();
            case SortMode.PRICE_ASC -> SortMode.PRICE_DESC;
            case SortMode.PRICE_DESC -> SortMode.REMAIN_ASC;
            case SortMode.REMAIN_ASC -> SortMode.REMAIN_DESC;
            case SortMode.REMAIN_DESC -> SortMode.EXPIRE_ASC;
            case SortMode.EXPIRE_ASC -> SortMode.EXPIRE_DESC;
            case SortMode.EXPIRE_DESC -> SortMode.PRICE_ASC;
        };
    }

    private String sortLabel(SortMode m) {
        return switch (m) {
            default -> throw new IncompatibleClassChangeError();
            case SortMode.PRICE_ASC -> this.tm.getMessage("market.gui.orders.sort-mode.price-asc", new Object[0]);
            case SortMode.PRICE_DESC -> this.tm.getMessage("market.gui.orders.sort-mode.price-desc", new Object[0]);
            case SortMode.REMAIN_ASC -> this.tm.getMessage("market.gui.orders.sort-mode.remaining-asc", new Object[0]);
            case SortMode.REMAIN_DESC -> this.tm.getMessage("market.gui.orders.sort-mode.remaining-desc", new Object[0]);
            case SortMode.EXPIRE_ASC -> this.tm.getMessage("market.gui.orders.sort-mode.expires-asc", new Object[0]);
            case SortMode.EXPIRE_DESC -> this.tm.getMessage("market.gui.orders.sort-mode.expires-desc", new Object[0]);
        };
    }

    private void openSelect(Player p, OrdersView parent, MarketOrder order, int suggestedQty) {
        SelectionView sv = new SelectionView(p.getUniqueId(), order, suggestedQty, parent.filter);
        this.selecting.put(p.getUniqueId(), sv);
        p.openInventory(this.buildSelect(sv));
    }

    private Inventory buildSelect(SelectionView sv) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.tm.getMessage("market.gui.orders.select.title", new Object[0]));
        ItemStack info = new ItemStack(sv.order.getMaterial());
        ItemMeta im = info.getItemMeta();
        if (im != null) {
            im.setDisplayName("\u00a7e" + this.tm.getMessage("market.gui.orders.item.header", sv.order.getId()));
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            lore.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.select.info.unit_price", this.format(sv.order.getUnitPrice()), new Object[0]))));
            lore.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.select.info.chosen", sv.quantity))));
            BigDecimal total = sv.order.getUnitPrice().multiply(new BigDecimal(sv.quantity)).setScale(2, RoundingMode.HALF_UP);
            lore.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.select.info.total", this.format(total), new Object[0]))));
            im.setLore(lore);
            info.setItemMeta(im);
        }
        inv.setItem(4, info);
        inv.setItem(10, this.amountItem(sv, 1, false));
        inv.setItem(11, this.amountItem(sv, 8, false));
        inv.setItem(12, this.amountItem(sv, 16, false));
        inv.setItem(13, this.amountItem(sv, 32, false));
        inv.setItem(14, this.amountItem(sv, sv.order.getRemainingQuantity(), true));
        ItemStack cancel = new ItemStack(Material.BARRIER);
        ItemMeta cm = cancel.getItemMeta();
        if (cm != null) {
            cm.setDisplayName("\u00a7c" + this.tm.getMessage("market.gui.orders.select.cancel", new Object[0]));
            cancel.setItemMeta(cm);
        }
        inv.setItem(22, cancel);
        ItemStack confirm = new ItemStack(Material.LIME_DYE);
        ItemMeta cfm = confirm.getItemMeta();
        if (cfm != null) {
            cfm.setDisplayName("\u00a7a" + this.tm.getMessage("market.gui.orders.select.confirm", new Object[0]));
            confirm.setItemMeta(cfm);
        }
        inv.setItem(16, confirm);
        return inv;
    }

    private ItemStack amountItem(SelectionView sv, int qty, boolean isMax) {
        ItemStack it = new ItemStack(Material.GOLD_NUGGET, Math.max(1, Math.min(64, qty)));
        ItemMeta im = it.getItemMeta();
        if (im != null) {
            if (isMax) {
                im.setDisplayName("\u00a76" + this.tm.getMessage("market.gui.orders.select.amount_max", new Object[0]));
            } else {
                im.setDisplayName("\u00a76" + this.tm.getMessage("market.gui.orders.select.amount", qty));
            }
            ArrayList<CallSite> lore = new ArrayList<CallSite>();
            BigDecimal total = sv.order.getUnitPrice().multiply(new BigDecimal(qty)).setScale(2, RoundingMode.HALF_UP);
            lore.add((CallSite)((Object)("\u00a77" + this.tm.getMessage("market.gui.orders.select.button_total", this.format(total), new Object[0]))));
            if (total.doubleValue() > this.getConfirmThreshold()) {
                lore.add((CallSite)((Object)("\u00a7e" + this.tm.getMessage("market.gui.orders.select.confirm_hint", new Object[0]))));
            }
            im.setLore(lore);
            it.setItemMeta(im);
        }
        return it;
    }

    private double getConfirmThreshold() {
        try {
            FileConfiguration cfg = ((EcoXpertPlugin)JavaPlugin.getPlugin(EcoXpertPlugin.class)).getServiceRegistry().getInstance(ConfigManager.class).getModuleConfig("market");
            return cfg.getDouble("orders.confirm_threshold", 5000.0);
        }
        catch (Exception e) {
            return 5000.0;
        }
    }

    @EventHandler
    public void onSelectClick(InventoryClickEvent e) {
        int chosen;
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player p = (Player)humanEntity;
        if (!e.getView().getTitle().equals(this.tm.getMessage("market.gui.orders.select.title", new Object[0]))) {
            return;
        }
        e.setCancelled(true);
        SelectionView sv = this.selecting.get(p.getUniqueId());
        if (sv == null) {
            return;
        }
        int slot = e.getRawSlot();
        if (slot == 22) {
            this.selecting.remove(p.getUniqueId());
            OrdersView view = this.open.get(p.getUniqueId());
            if (view != null) {
                p.openInventory(this.build(view));
            } else {
                p.closeInventory();
            }
            return;
        }
        if (slot == 16) {
            int qty = Math.max(1, Math.min(sv.quantity, sv.order.getRemainingQuantity()));
            this.executePurchase(p, sv, qty);
            return;
        }
        switch (slot) {
            case 10: {
                int n = 1;
                break;
            }
            case 11: {
                int n = 8;
                break;
            }
            case 12: {
                int n = 16;
                break;
            }
            case 13: {
                int n = 32;
                break;
            }
            case 14: {
                int n = sv.order.getRemainingQuantity();
                break;
            }
            default: {
                int n = chosen = -1;
            }
        }
        if (chosen > 0) {
            sv.quantity = chosen;
            BigDecimal total = sv.order.getUnitPrice().multiply(new BigDecimal(sv.quantity));
            if (total.doubleValue() <= this.getConfirmThreshold()) {
                this.executePurchase(p, sv, chosen);
            } else {
                p.getOpenInventory().getTopInventory().setContents(this.buildSelect(sv).getContents());
            }
        }
    }

    private void executePurchase(Player p, SelectionView sv, int qty) {
        this.orderService.buyFromOrder(p, sv.order.getId(), qty).thenAccept(msg -> Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), () -> {
            p.sendMessage(this.tm.getMessage("prefix", new Object[0]) + msg);
            this.selecting.remove(p.getUniqueId());
            this.orderService.listOpenOrders(sv.filter).thenAccept(list -> Bukkit.getScheduler().runTask((Plugin)JavaPlugin.getProvidingPlugin(this.getClass()), () -> {
                OrdersView view = this.open.get(p.getUniqueId());
                if (view == null) {
                    view = new OrdersView(p.getUniqueId(), (List<MarketOrder>)list, 0, sv.filter, SortMode.PRICE_ASC);
                } else {
                    view.orders = list;
                    int tp = (int)Math.ceil((double)view.orders.size() / 45.0);
                    view.page = tp == 0 ? 0 : Math.min(view.page, Math.max(0, tp - 1));
                }
                view.orders = this.applySort(view.orders, view.sortMode);
                this.open.put(p.getUniqueId(), view);
                p.openInventory(this.build(view));
            }));
        }));
    }

    private static class OrdersView {
        final UUID player;
        List<MarketOrder> orders;
        int page;
        final Material filter;
        SortMode sortMode;

        OrdersView(UUID player, List<MarketOrder> orders, int page, Material filter, SortMode sortMode) {
            this.player = player;
            this.orders = orders;
            this.page = page;
            this.filter = filter;
            this.sortMode = sortMode;
        }
    }

    private static enum SortMode {
        PRICE_ASC,
        PRICE_DESC,
        REMAIN_ASC,
        REMAIN_DESC,
        EXPIRE_ASC,
        EXPIRE_DESC;

    }

    private static class SelectionView {
        final UUID player;
        final MarketOrder order;
        int quantity;
        final Material filter;

        SelectionView(UUID player, MarketOrder order, int quantity, Material filter) {
            this.player = player;
            this.order = order;
            this.quantity = quantity;
            this.filter = filter;
        }
    }
}

