/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.fabric.api.permissions.v0;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import me.lucko.fabric.api.permissions.v0.OfflinePermissionCheckEvent;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import me.lucko.fabric.api.permissions.v0.Util;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_11560;
import net.minecraft.class_12087;
import net.minecraft.class_12094;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public interface Permissions {
    @NotNull
    public static TriState getPermissionValue(@NotNull class_2172 source, @NotNull String permission) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(permission, "permission");
        return ((PermissionCheckEvent)PermissionCheckEvent.EVENT.invoker()).onPermissionCheck(source, permission);
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission, boolean defaultValue) {
        return Permissions.getPermissionValue(source, permission).orElse(defaultValue);
    }

    @Deprecated
    public static boolean check(@NotNull class_2172 source, @NotNull String permission, int defaultRequiredLevel) {
        return Permissions.check(source, permission, Util.permissionLevelFromInt(defaultRequiredLevel));
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission, @NotNull class_12094 defaultRequiredLevel) {
        return Permissions.getPermissionValue(source, permission).orElseGet(() -> source.method_75037().hasPermission((class_12087)new class_12087.class_12089(defaultRequiredLevel)));
    }

    public static boolean check(@NotNull class_2172 source, @NotNull String permission) {
        return Permissions.getPermissionValue(source, permission).orElse(false);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(permission, "permission");
        return player -> Permissions.check((class_2172)player, permission, defaultValue);
    }

    @Deprecated
    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission, int defaultRequiredLevel) {
        Objects.requireNonNull(permission, "permission");
        class_12094 level = Util.permissionLevelFromInt(defaultRequiredLevel);
        return player -> Permissions.check((class_2172)player, permission, level);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission, class_12094 defaultRequiredLevel) {
        Objects.requireNonNull(permission, "permission");
        Objects.requireNonNull(defaultRequiredLevel, "defaultRequiredLevel");
        return player -> Permissions.check((class_2172)player, permission, defaultRequiredLevel);
    }

    @NotNull
    public static Predicate<class_2168> require(@NotNull String permission) {
        Objects.requireNonNull(permission, "permission");
        return player -> Permissions.check((class_2172)player, permission);
    }

    @NotNull
    public static TriState getPermissionValue(@NotNull class_1297 entity, @NotNull String permission) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.getPermissionValue((class_2172)Util.commandSourceFromEntity(entity), permission);
    }

    public static boolean check(@NotNull class_1297 entity, @NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.check((class_2172)Util.commandSourceFromEntity(entity), permission, defaultValue);
    }

    @Deprecated
    public static boolean check(@NotNull class_1297 entity, @NotNull String permission, int defaultRequiredLevel) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.check((class_2172)Util.commandSourceFromEntity(entity), permission, defaultRequiredLevel);
    }

    public static boolean check(@NotNull class_1297 entity, @NotNull String permission, class_12094 defaultRequiredLevel) {
        Objects.requireNonNull(entity, "entity");
        Objects.requireNonNull(defaultRequiredLevel, "permissionLevel");
        return Permissions.check((class_2172)Util.commandSourceFromEntity(entity), permission, defaultRequiredLevel);
    }

    public static boolean check(@NotNull class_1297 entity, @NotNull String permission) {
        Objects.requireNonNull(entity, "entity");
        return Permissions.check((class_2172)Util.commandSourceFromEntity(entity), permission);
    }

    @NotNull
    public static CompletableFuture<TriState> getPermissionValue(@NotNull UUID uuid, @NotNull String permission) {
        Objects.requireNonNull(uuid, "uuid");
        Objects.requireNonNull(permission, "permission");
        return ((OfflinePermissionCheckEvent)OfflinePermissionCheckEvent.EVENT.invoker()).onPermissionCheck(uuid, permission);
    }

    public static CompletableFuture<Boolean> check(@NotNull UUID uuid, @NotNull String permission, boolean defaultValue) {
        return Permissions.getPermissionValue(uuid, permission).thenApplyAsync(state -> state.orElse(defaultValue));
    }

    public static CompletableFuture<Boolean> check(@NotNull UUID uuid, @NotNull String permission) {
        return Permissions.getPermissionValue(uuid, permission).thenApplyAsync(state -> state.orElse(false));
    }

    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(profile, "profile");
        return Permissions.check(profile.id(), permission, defaultValue);
    }

    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission) {
        Objects.requireNonNull(profile, "profile");
        return Permissions.check(profile.id(), permission);
    }

    @Deprecated
    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission, int defaultRequiredLevel, @NotNull MinecraftServer server) {
        return Permissions.check(profile, permission, Util.permissionLevelFromInt(defaultRequiredLevel), server);
    }

    public static CompletableFuture<Boolean> check(@NotNull GameProfile profile, @NotNull String permission, @NotNull class_12094 defaultRequiredLevel, @NotNull MinecraftServer server) {
        Objects.requireNonNull(profile, "profile");
        Objects.requireNonNull(defaultRequiredLevel, "defaultRequiredLevel");
        Objects.requireNonNull(server, "server");
        BooleanSupplier permissionLevelCheck = () -> server.method_3835(new class_11560(profile)).method_75009().method_75028(defaultRequiredLevel);
        return Permissions.getPermissionValue(profile.id(), permission).thenApplyAsync(state -> state.orElseGet(permissionLevelCheck));
    }

    public static CompletableFuture<Boolean> check(@NotNull class_11560 entry, @NotNull String permission, boolean defaultValue) {
        Objects.requireNonNull(entry, "entry");
        return Permissions.check(entry.comp_4422(), permission, defaultValue);
    }

    public static CompletableFuture<Boolean> check(@NotNull class_11560 entry, @NotNull String permission) {
        Objects.requireNonNull(entry, "entry");
        return Permissions.check(entry.comp_4422(), permission);
    }

    @Deprecated
    public static CompletableFuture<Boolean> check(@NotNull class_11560 entry, @NotNull String permission, int defaultRequiredLevel, @NotNull MinecraftServer server) {
        return Permissions.check(entry, permission, Util.permissionLevelFromInt(defaultRequiredLevel), server);
    }

    public static CompletableFuture<Boolean> check(@NotNull class_11560 entry, @NotNull String permission, class_12094 defaultRequiredLevel, @NotNull MinecraftServer server) {
        Objects.requireNonNull(entry, "entry");
        Objects.requireNonNull(defaultRequiredLevel, "defaultRequiredLevel");
        Objects.requireNonNull(server, "server");
        BooleanSupplier permissionLevelCheck = () -> server.method_3835(entry).method_75009().method_75028(defaultRequiredLevel);
        return Permissions.getPermissionValue(entry.comp_4422(), permission).thenApplyAsync(state -> state.orElseGet(permissionLevelCheck));
    }
}

