/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.file;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.data.ItemData;
import xyz.srnyx.personalphantoms.libs.annoyingapi.file.PlayableSound;
import xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities.FileUtility;
import xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities.parents.Stringable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.RefNamespacedKey;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.RefRegistry;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.RefSoundCategory;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.attribute.RefAttribute;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.attribute.RefAttributeModifier;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.inventory.RefShapedRecipe;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.inventory.RefShapelessRecipe;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.inventory.meta.RefDamageable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.inventory.meta.RefItemMeta;
import xyz.srnyx.personalphantoms.libs.annoyingapi.reflection.org.bukkit.potion.RefPotionEffect;
import xyz.srnyx.personalphantoms.libs.annoyingapi.utility.BukkitUtility;
import xyz.srnyx.personalphantoms.libs.annoyingapi.utility.ReflectionUtility;

public class AnnoyingFile<T extends AnnoyingFile<T>>
extends YamlConfiguration {
    @NotNull
    public final AnnoyingPlugin plugin;
    @NotNull
    public final File file;
    @NotNull
    protected final Options<?> fileOptions;

    public AnnoyingFile(@NotNull AnnoyingPlugin plugin, @NotNull File file, @Nullable Options<?> fileOptions) {
        this.plugin = plugin;
        this.file = file;
        this.fileOptions = fileOptions == null ? new Options() : fileOptions;
    }

    public AnnoyingFile(@NotNull AnnoyingPlugin plugin, @NotNull File file) {
        this(plugin, file, null);
    }

    public AnnoyingFile(@NotNull AnnoyingPlugin plugin, @NotNull String path, @Nullable Options<?> fileOptions) {
        this(plugin, new File(plugin.getDataFolder(), path), fileOptions);
    }

    public AnnoyingFile(@NotNull AnnoyingPlugin plugin, @NotNull String path) {
        this(plugin, path, null);
    }

    @NotNull
    public String toString() {
        return Stringable.toString((Object)this);
    }

    public void create() {
        Path filePath = this.file.toPath();
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            Files.createFile(filePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean load() {
        if (this.fileOptions.replace) {
            this.create();
        } else if (!this.file.exists()) {
            if (this.fileOptions.canBeEmpty) {
                this.create();
            } else {
                return true;
            }
        }
        try {
            this.load(this.file);
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean delete(boolean silentFail) {
        return FileUtility.deleteFile(this.file.toPath(), silentFail);
    }

    public boolean delete() {
        return this.delete(false);
    }

    @NotNull
    public T setChain(@NotNull String path, @Nullable Object value) {
        this.set(path, value);
        return (T)((Object)this);
    }

    public boolean setSave(@NotNull String path, @Nullable Object value) {
        this.set(path, value);
        return this.save();
    }

    public boolean save() {
        if (!this.fileOptions.canBeEmpty && this.getKeys(true).isEmpty()) {
            if (this.file.exists()) {
                this.delete();
            }
            return true;
        }
        if (this.fileOptions.canBeEmpty && !this.file.exists()) {
            this.create();
        }
        try {
            this.save(this.file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void log(@NotNull Level level, @Nullable String key, @NotNull String message) {
        AnnoyingPlugin.log(level, ChatColor.getLastColors((String)message) + this.file.getPath() + (key == null ? "" : ", " + key) + " | " + message);
    }

    @NotNull
    public <G> Optional<G> getDef(@NotNull String path) {
        Object value = this.getDefault(path);
        return value != null ? Optional.of(value) : Optional.empty();
    }

    @NotNull
    public Optional<ConfigurationSection> getConfigurationSectionOptional(@NotNull String path) {
        return Optional.ofNullable(this.getConfigurationSection(path));
    }

    @NotNull
    public Optional<Sound> getSound(@NotNull String path) {
        String sound = this.getString(path);
        if (sound != null) {
            try {
                return Optional.of(Sound.valueOf((String)sound.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getDef(path);
    }

    @NotNull
    public Optional<PlayableSound> getPlayableSound(@NotNull String path) {
        Optional<PlayableSound> def = this.getDef(path);
        Optional<Sound> sound = this.getSound(path + ".sound");
        if (!sound.isPresent()) {
            return def;
        }
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section == null) {
            return def;
        }
        Enum category = null;
        String categoryString = section.getString("category");
        if (categoryString != null) {
            try {
                category = ReflectionUtility.getEnumValue(1, 11, 0, RefSoundCategory.SOUND_CATEGORY_ENUM, categoryString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.log(Level.WARNING, path, "&cInvalid sound category: &4" + categoryString);
            }
        }
        return Optional.of(new PlayableSound(sound.get(), category, (float)section.getDouble("volume", 1.0), (float)section.getDouble("pitch", 1.0)));
    }

    @NotNull
    public Optional<PotionEffect> getPotionEffect(@NotNull String path) {
        return this.getPotionEffect(path, true);
    }

    @NotNull
    public Optional<PotionEffect> getPotionEffect(@NotNull String path, boolean log) {
        Optional<PotionEffect> def = this.getDef(path);
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section == null) {
            return def;
        }
        String typeString = section.getString("type");
        if (typeString == null) {
            if (log) {
                this.log(Level.WARNING, path, "&cInvalid potion effect, missing type");
            }
            return def;
        }
        Optional<PotionEffectType> typeOptional = RefRegistry.getEffect(typeString);
        if (!typeOptional.isPresent()) {
            if (log) {
                this.log(Level.WARNING, path, "&cInvalid potion effect type: &4" + typeString);
            }
            return def;
        }
        PotionEffectType type = typeOptional.get();
        int duration = section.getInt("duration", 1);
        int amplifier = section.getInt("amplifier", 0);
        boolean ambient = section.getBoolean("ambient", false);
        boolean particles = section.getBoolean("particles", true);
        if (RefPotionEffect.POTION_EFFECT_CONSTRUCTOR_6 != null) {
            try {
                return Optional.of(RefPotionEffect.POTION_EFFECT_CONSTRUCTOR_6.newInstance(type, duration, amplifier, ambient, particles, section.getBoolean("icon", true)));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return Optional.of(new PotionEffect(type, duration, amplifier, ambient, particles));
    }

    @NotNull
    public <G> Optional<G> getAttributeModifier(@NotNull String path) {
        return this.getAttributeModifier(path, true);
    }

    @NotNull
    public <G> Optional<G> getAttributeModifier(@NotNull String path, boolean log) {
        Enum operation;
        Optional<G> def = this.getDef(path);
        if (RefAttributeModifier.RefOperation.ATTRIBUTE_MODIFIER_OPERATION_ENUM == null) {
            return def;
        }
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section == null) {
            return def;
        }
        String name = section.getString("name");
        String operationString = section.getString("operation");
        if (name == null || operationString == null) {
            if (log) {
                this.log(Level.WARNING, path, "&cInvalid attribute modifier, missing name and/or operation");
            }
            return def;
        }
        try {
            operation = Enum.valueOf(RefAttributeModifier.RefOperation.ATTRIBUTE_MODIFIER_OPERATION_ENUM, operationString);
        }
        catch (IllegalArgumentException e) {
            if (log) {
                this.log(Level.WARNING, path, "&cInvalid attribute modifier operation: &4" + operationString);
            }
            return def;
        }
        double amount = section.getDouble("amount");
        if (RefAttributeModifier.ATTRIBUTE_MODIFIER_CONSTRUCTOR_5 != null) {
            EquipmentSlot slot;
            block16: {
                slot = null;
                String equipmentSlotString = section.getString("slot");
                if (equipmentSlotString != null) {
                    try {
                        slot = EquipmentSlot.valueOf((String)equipmentSlotString);
                    }
                    catch (IllegalArgumentException e) {
                        if (!log) break block16;
                        this.log(Level.WARNING, path, "&cInvalid equipment slot: &4" + equipmentSlotString);
                    }
                }
            }
            try {
                return Optional.of(RefAttributeModifier.ATTRIBUTE_MODIFIER_CONSTRUCTOR_5.newInstance(UUID.randomUUID(), name, amount, operation, slot));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                return def;
            }
        }
        if (RefAttributeModifier.ATTRIBUTE_MODIFIER_CONSTRUCTOR_3 != null) {
            try {
                return Optional.of(RefAttributeModifier.ATTRIBUTE_MODIFIER_CONSTRUCTOR_3.newInstance(name, amount, operation));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return def;
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path) {
        return this.getItemStackOptional(path, true).orElse(null);
    }

    @Nullable
    public ItemStack getItemStack(@NotNull String path, @Nullable ItemStack def) {
        return this.getItemStackOptional(path, true).orElse(def);
    }

    @NotNull
    public Optional<ItemStack> getItemStackOptional(@NotNull String path) {
        return this.getItemStackOptional(path, true);
    }

    @NotNull
    public Optional<ItemStack> getItemStackOptional(@NotNull String path, boolean log) {
        Optional<ItemStack> def = this.getDef(path);
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section == null) {
            return def;
        }
        String materialString = section.getString("material");
        if (materialString == null) {
            if (log) {
                this.log(Level.WARNING, path, "&cInvalid material, missing material");
            }
            return def;
        }
        Material material = Material.matchMaterial((String)materialString);
        if (material == null) {
            if (log) {
                this.log(Level.WARNING, path, "&cInvalid material for: &4" + materialString);
            }
            return def;
        }
        int amount = section.getInt("amount", 1);
        int damage = section.getInt("damage", 0);
        boolean useDamageable = RefDamageable.DAMAGEABLE_CLASS != null && RefDamageable.DAMAGEABLE_SET_DAMAGE_METHOD != null;
        ItemStack item = useDamageable ? new ItemStack(material, amount) : new ItemStack(material, amount, (short)damage);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String name;
            if (useDamageable && RefDamageable.DAMAGEABLE_CLASS.isInstance(meta)) {
                try {
                    RefDamageable.DAMAGEABLE_SET_DAMAGE_METHOD.invoke((Object)meta, damage);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if ((name = section.getString("name")) != null) {
                meta.setDisplayName(BukkitUtility.color(name));
            }
            meta.setLore(BukkitUtility.colorCollection(section.getStringList("lore")));
            ConfigurationSection enchantmentsSection = section.getConfigurationSection("enchantments");
            if (enchantmentsSection != null) {
                for (Object enchantmentKey : enchantmentsSection.getKeys(false)) {
                    Optional<Enchantment> enchantment = RefRegistry.getEnchantment((String)enchantmentKey);
                    if (!enchantment.isPresent()) {
                        if (!log) continue;
                        this.log(Level.WARNING, path, "&cInvalid enchantment: &4" + (String)enchantmentKey);
                        continue;
                    }
                    meta.addEnchant(enchantment.get(), enchantmentsSection.getInt((String)enchantmentKey), true);
                }
            }
            section.getStringList("flags").stream().map(string -> {
                try {
                    return ItemFlag.valueOf((String)string.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    if (log) {
                        this.log(Level.WARNING, section.getCurrentPath() + ".flags", "&cInvalid item flag: &4" + string);
                    }
                    return null;
                }
            }).forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0}));
            if (RefItemMeta.ITEM_META_SET_UNBREAKABLE != null) {
                try {
                    RefItemMeta.ITEM_META_SET_UNBREAKABLE.invoke((Object)meta, section.getBoolean("unbreakable"));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            if (RefAttribute.ATTRIBUTE_ENUM != null && RefItemMeta.ITEM_META_ADD_ATTRIBUTE_MODIFIER != null) {
                int customModelData;
                ConfigurationSection attributeModifiersSection = section.getConfigurationSection("attribute-modifiers");
                if (attributeModifiersSection != null) {
                    for (String attributeKey : attributeModifiersSection.getKeys(false)) {
                        Enum attribute;
                        String pathString = attributeModifiersSection.getCurrentPath() + "." + attributeKey;
                        try {
                            attribute = Enum.valueOf(RefAttribute.ATTRIBUTE_ENUM, attributeKey.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            if (!log) continue;
                            this.log(Level.WARNING, pathString, "&cInvalid attribute: &4" + attributeKey);
                            continue;
                        }
                        Optional attributeModifier = this.getAttributeModifier(pathString);
                        if (!attributeModifier.isPresent()) continue;
                        try {
                            RefItemMeta.ITEM_META_ADD_ATTRIBUTE_MODIFIER.invoke((Object)meta, attribute, attributeModifier.get());
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (RefItemMeta.ITEM_META_SET_CUSTOM_MODEL_DATA != null && (customModelData = section.getInt("custom-model-data")) != 0) {
                    try {
                        RefItemMeta.ITEM_META_SET_CUSTOM_MODEL_DATA.invoke((Object)meta, customModelData);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
            item.setItemMeta(meta);
        }
        ItemData dataUtility = new ItemData(this.plugin, item);
        ConfigurationSection dataSection = section.getConfigurationSection("data");
        if (dataSection != null) {
            for (String key : dataSection.getKeys(false)) {
                dataUtility.set(key, (Object)dataSection.getString(key));
            }
        }
        return Optional.of((ItemStack)dataUtility.target);
    }

    @NotNull
    public Optional<Recipe> getRecipe(@NotNull String path) {
        return this.getRecipe(path, null, null);
    }

    @NotNull
    public Optional<Recipe> getRecipe(@NotNull String path, @Nullable UnaryOperator<ItemStack> itemFunction) {
        return this.getRecipe(path, itemFunction, null);
    }

    @NotNull
    public Optional<Recipe> getRecipe(@NotNull String path, @Nullable UnaryOperator<ItemStack> itemFunction, @Nullable String name) {
        return this.getRecipe(path, itemFunction, name, true);
    }

    @NotNull
    public Optional<Recipe> getRecipe(@NotNull String path, @Nullable UnaryOperator<ItemStack> itemFunction, @Nullable String name, boolean log) {
        ShapedRecipe shaped;
        Optional<Recipe> def = this.getDef(path);
        ConfigurationSection section = this.getConfigurationSection(path);
        if (section == null) {
            return def;
        }
        ConfigurationSection ingredients = section.getConfigurationSection("ingredients");
        List shape = section.getStringList("shape").stream().map(String::toUpperCase).collect(Collectors.toList());
        ItemStack result = this.getItemStack(path + ".result");
        if (ingredients == null || shape.isEmpty()) {
            return def;
        }
        HashMap<Character, Material> ingredientMaterials = new HashMap<Character, Material>();
        for (Map.Entry entry : ingredients.getValues(false).entrySet()) {
            String key = (String)entry.getKey();
            String value = String.valueOf(entry.getValue());
            Material material = Material.matchMaterial((String)value);
            if (material == null) {
                if (!log) continue;
                this.log(Level.WARNING, ingredients.getCurrentPath() + "." + key, "&cInvalid material: &4" + value);
                continue;
            }
            ingredientMaterials.put(Character.valueOf(key.toUpperCase().charAt(0)), material);
        }
        if (ingredientMaterials.isEmpty()) {
            return def;
        }
        if (itemFunction != null) {
            result = (ItemStack)itemFunction.apply(result);
        }
        if (result == null) {
            return def;
        }
        if (name == null) {
            String[] split = path.split("\\.");
            name = split[split.length - 1];
        }
        if (section.getBoolean("shapeless")) {
            ShapelessRecipe shapeless;
            if (RefShapelessRecipe.SHAPELESS_RECIPE_CONSTRUCTOR != null && RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR != null) {
                try {
                    shapeless = RefShapelessRecipe.SHAPELESS_RECIPE_CONSTRUCTOR.newInstance(RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, name}), result);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    shapeless = new ShapelessRecipe(result);
                }
            } else {
                shapeless = new ShapelessRecipe(result);
            }
            for (Map.Entry entry : ingredientMaterials.entrySet()) {
                shapeless.addIngredient(shape.stream().mapToInt(s -> s.length() - s.replace(((Character)entry.getKey()).toString(), "").length()).sum(), (Material)entry.getValue());
            }
            return Optional.of(shapeless);
        }
        if (RefShapedRecipe.SHAPED_RECIPE_CONSTRUCTOR != null && RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR != null) {
            try {
                shaped = RefShapedRecipe.SHAPED_RECIPE_CONSTRUCTOR.newInstance(RefNamespacedKey.NAMESPACED_KEY_CONSTRUCTOR.newInstance(new Object[]{this.plugin, name}), result);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                shaped = new ShapedRecipe(result);
            }
        } else {
            shaped = new ShapedRecipe(result);
        }
        shaped.shape((String[])shape.stream().map(string -> string.replace("-", " ")).toArray(String[]::new));
        ingredientMaterials.forEach((arg_0, arg_1) -> ((ShapedRecipe)shaped).setIngredient(arg_0, arg_1));
        return Optional.of(shaped);
    }

    public static class Options<G extends Options<G>>
    extends Stringable {
        public boolean canBeEmpty = true;
        public boolean replace = false;

        @NotNull
        public static <H extends Options<H>> H load(@NotNull H options, @NotNull ConfigurationSection section) {
            if (section.contains("canBeEmpty")) {
                options.canBeEmpty = section.getBoolean("canBeEmpty");
            }
            if (section.contains("replace")) {
                options.replace = section.getBoolean("replace");
            }
            return options;
        }

        @NotNull
        public static <R extends Options<R>> Options<R> load(@NotNull ConfigurationSection section) {
            Options options = new Options();
            if (section.contains("canBeEmpty")) {
                options.canBeEmpty = section.getBoolean("canBeEmpty");
            }
            return options;
        }

        @NotNull
        public G canBeEmpty(boolean canBeEmpty) {
            this.canBeEmpty = canBeEmpty;
            return (G)this;
        }

        @NotNull
        public G replace(boolean replace) {
            this.replace = replace;
            return (G)this;
        }
    }
}

