/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities;

import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MiscUtility {
    @NotNull
    public static final Random RANDOM = new Random();
    @NotNull
    public static final JsonParser JSON_PARSER = new JsonParser();
    public static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    @NotNull
    public static final ScheduledExecutorService CPU_SCHEDULER = Executors.newScheduledThreadPool(AVAILABLE_PROCESSORS);
    @NotNull
    public static final ScheduledExecutorService IO_SCHEDULER = Executors.newScheduledThreadPool(AVAILABLE_PROCESSORS * 2);

    @SafeVarargs
    @NotNull
    public static <R> Optional<R> handleException(@NotNull Supplier<R> supplier, Class<? extends Throwable> ... throwables) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (Exception e) {
            for (Class<? extends Throwable> throwable : throwables) {
                if (!throwable.isInstance(e)) continue;
                return Optional.empty();
            }
            throw e;
        }
    }

    @NotNull
    public static <R> Optional<R> handleException(@NotNull Supplier<R> supplier) {
        return MiscUtility.handleException(supplier, Exception.class);
    }

    @NotNull
    public static Set<String> getEnumNames(@NotNull Class<? extends Enum<?>> enumClass) {
        return Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    private MiscUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

