/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.options;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.file.AnnoyingFile;
import xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities.MapGenerator;
import xyz.srnyx.personalphantoms.libs.annoyingapi.libs.javautilities.parents.Stringable;

public class DataOptions
extends Stringable {
    public boolean enabled = false;
    @NotNull
    public Map<String, Set<String>> tables = MapGenerator.HASH_MAP.mapOf("entities", new HashSet<String>(Collections.singleton("target")));
    public boolean useCacheDefault = true;
    @NotNull
    public Entities entities = new Entities();

    @NotNull
    public DataOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @NotNull
    public DataOptions tables(@NotNull Map<String, Collection<String>> tables) {
        this.tables.putAll(tables.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put(((String)entry.getKey()).toLowerCase(), (Set)((Collection)entry.getValue()).stream().map(String::toLowerCase).collect(HashSet::new, HashSet::add, AbstractCollection::addAll)), HashMap::putAll));
        return this;
    }

    @NotNull
    public DataOptions table(@NotNull String table, @NotNull Collection<String> columns) {
        this.tables.put(table.toLowerCase(), columns.stream().map(String::toLowerCase).collect(HashSet::new, HashSet::add, AbstractCollection::addAll));
        return this;
    }

    @NotNull
    public DataOptions table(@NotNull String table, String ... columns) {
        return this.table(table, Arrays.asList(columns));
    }

    @NotNull
    public DataOptions entityDataColumns(@NotNull Collection<String> columns) {
        Set<String> entityDataColumns = this.tables.get("entities");
        if (entityDataColumns == null) {
            return this.table("entities", new HashSet<String>(columns));
        }
        entityDataColumns.addAll(columns);
        return this;
    }

    @NotNull
    public DataOptions entityDataColumns(String ... columns) {
        return this.entityDataColumns(Arrays.asList(columns));
    }

    @NotNull
    public DataOptions useCacheDefault(boolean useCacheDefault) {
        this.useCacheDefault = useCacheDefault;
        return this;
    }

    @NotNull
    public DataOptions entities(@NotNull Entities entities) {
        this.entities = entities;
        return this;
    }

    @NotNull
    public DataOptions entities(@NotNull Consumer<Entities> consumer) {
        consumer.accept(this.entities);
        return this;
    }

    @NotNull
    public static DataOptions load(@NotNull ConfigurationSection section) {
        ConfigurationSection entitiesSection;
        ConfigurationSection tablesSection;
        DataOptions options = new DataOptions();
        if (section.contains("enabled")) {
            options.enabled(section.getBoolean("enabled"));
        }
        if ((tablesSection = section.getConfigurationSection("tables")) != null) {
            options.tables(tablesSection.getKeys(false).stream().collect(HashMap::new, (map, table) -> map.put(table, tablesSection.getStringList(table)), HashMap::putAll));
        }
        if (section.contains("useCacheDefault")) {
            options.useCacheDefault(section.getBoolean("useCacheDefault"));
        }
        if ((entitiesSection = section.getConfigurationSection("entities")) != null) {
            options.entities(Entities.load(entitiesSection));
        }
        return options;
    }

    public static class Entities
    extends Stringable {
        @Deprecated
        @NotNull
        public String path = "entities";
        @Deprecated
        @Nullable
        public AnnoyingFile.Options<?> fileOptions = new AnnoyingFile.Options().canBeEmpty(false);
        @Deprecated
        @NotNull
        public String section = "data";

        @NotNull
        public static Entities load(@NotNull ConfigurationSection section) {
            String sectionString;
            ConfigurationSection fileOptionsSection;
            Entities options = new Entities();
            String pathString = section.getString("path");
            if (pathString != null) {
                options.path(pathString);
            }
            if ((fileOptionsSection = section.getConfigurationSection("fileOptions")) != null) {
                options.fileOptions(AnnoyingFile.Options.load(fileOptionsSection));
            }
            if ((sectionString = section.getString("section")) != null) {
                options.node(sectionString);
            }
            return options;
        }

        @Deprecated
        @NotNull
        public Entities path(@NotNull String path) {
            this.path = path;
            return this;
        }

        @Deprecated
        @NotNull
        public Entities fileOptions(@Nullable AnnoyingFile.Options<?> fileOptions) {
            this.fileOptions = fileOptions;
            return this;
        }

        @Deprecated
        @NotNull
        public Entities fileOptions(@NotNull Consumer<AnnoyingFile.Options<?>> consumer) {
            AnnoyingFile.Options options = new AnnoyingFile.Options();
            consumer.accept(options);
            return this.fileOptions(options);
        }

        @Deprecated
        @NotNull
        public Entities node(@NotNull String node) {
            this.section = node;
            return this;
        }
    }
}

