/*
 * Decompiled with CFR 0.152.
 */
package xyz.srnyx.personalphantoms.libs.annoyingapi.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.srnyx.personalphantoms.libs.annoyingapi.AnnoyingPlugin;
import xyz.srnyx.personalphantoms.libs.annoyingapi.file.AnnoyingFile;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.ConnectionException;
import xyz.srnyx.personalphantoms.libs.annoyingapi.storage.StorageMethod;

public class StorageConfig {
    @NotNull
    public final AnnoyingFile<?> file;
    @NotNull
    public final StorageMethod method;
    @NotNull
    public final Cache cache;
    @Nullable
    public final RemoteConnection remoteConnection;
    @NotNull
    public final String migrationLogPrefix;

    public StorageConfig(@NotNull AnnoyingFile<?> file) {
        this.file = file;
        this.cache = new Cache();
        StorageMethod getMethod = StorageMethod.get(file.getString("method"));
        this.migrationLogPrefix = "&4" + file.file.getName() + " (" + (Object)((Object)getMethod) + ") &8|&c ";
        if (!getMethod.isRemote()) {
            this.method = getMethod;
            this.remoteConnection = null;
            return;
        }
        ConfigurationSection remoteSection = file.getConfigurationSection("remote-connection");
        if (remoteSection == null) {
            AnnoyingPlugin.log(Level.WARNING, file.file.getPath() + " | A remote storage method is used but no remote connection is specified, using H2 instead");
            this.method = StorageMethod.H2;
            this.remoteConnection = null;
            return;
        }
        this.method = getMethod;
        this.remoteConnection = new RemoteConnection(remoteSection);
    }

    @NotNull
    public Connection createConnection() throws ConnectionException {
        File folder;
        Optional<String> driver;
        if (this.method.url == null) {
            throw new IllegalStateException("The storage method " + (Object)((Object)this.method) + " is not an SQL method");
        }
        AnnoyingPlugin plugin = this.file.plugin;
        String url = this.method.url.apply(plugin.getDataFolder());
        Properties properties = new Properties();
        if (this.remoteConnection != null) {
            url = url + this.remoteConnection.host + ":" + this.remoteConnection.port + "/" + this.remoteConnection.database;
            properties.putAll(this.remoteConnection.properties);
            if (this.remoteConnection.username != null) {
                properties.setProperty("user", this.remoteConnection.username);
            }
            if (this.remoteConnection.password != null) {
                properties.setProperty("password", this.remoteConnection.password);
            }
        }
        if (!(driver = this.method.getDriver()).isPresent()) {
            throw new ConnectionException("Failed to get driver for " + (Object)((Object)this.method), url, properties);
        }
        if (this.method == StorageMethod.SQLITE && !(folder = new File(plugin.getDataFolder(), "data/sqlite")).exists() && !folder.mkdirs()) {
            throw new ConnectionException("Failed to create SQLite parent directories", url, properties);
        }
        if (this.method.library != null) {
            try {
                Class<?> driverClass = plugin.libraryManager.loadLibraryIsolated(this.method.library).loadClass(driver.get());
                return (Connection)driverClass.getMethod("connect", String.class, Properties.class).invoke(driverClass.newInstance(), url, properties);
            }
            catch (Exception e) {
                throw new ConnectionException(e, url, properties);
            }
        }
        try {
            Class.forName(driver.get());
            return DriverManager.getConnection(url, properties);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new ConnectionException(e, url, properties);
        }
    }

    public class Cache {
        public final boolean enabled;
        @NotNull
        public final Set<SaveOn> saveOn;
        public final long interval;

        public Cache() {
            this.enabled = StorageConfig.this.file.getBoolean("cache.enabled");
            this.interval = StorageConfig.this.file.getLong("cache.interval");
            HashSet<SaveOn> providedSaveOns = StorageConfig.this.file.getStringList("cache.save-on").stream().map(string -> SaveOn.fromString(string).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
            this.saveOn = !providedSaveOns.isEmpty() ? providedSaveOns : new HashSet<SaveOn>(Arrays.asList(SaveOn.values()));
        }
    }

    public class RemoteConnection {
        @NotNull
        public final String host;
        public final int port;
        @NotNull
        public final String database;
        @Nullable
        public final String username;
        @Nullable
        public final String password;
        @NotNull
        public final String tablePrefix;
        @NotNull
        public final Map<String, String> properties;

        public RemoteConnection(ConfigurationSection section) {
            this.username = StorageConfig.this.file.getString("remote-connection.username");
            this.password = StorageConfig.this.file.getString("remote-connection.password");
            this.tablePrefix = StorageConfig.this.file.getString("remote-connection.table-prefix", StorageConfig.this.file.plugin.getName().toLowerCase().replaceAll("[^a-z0-9]", "") + "_");
            this.properties = new HashMap<String, String>();
            String getHost = section.getString("host");
            if (getHost == null) {
                throw new IllegalArgumentException("A remote storage method is used but no remote host is specified");
            }
            this.host = getHost;
            Integer getPort = section.getInt("port");
            if (getPort == 0) {
                getPort = StorageConfig.this.method.defaultPort;
            }
            if (getPort == null) {
                throw new IllegalArgumentException("A remote storage method is used but no remote port is specified");
            }
            this.port = getPort;
            String getDatabase = section.getString("database");
            if (getDatabase == null) {
                throw new IllegalArgumentException("A remote storage method is used but no remote database is specified");
            }
            this.database = getDatabase;
            ConfigurationSection propertiesSection = section.getConfigurationSection("properties");
            if (propertiesSection != null) {
                this.properties.putAll(propertiesSection.getValues(false).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString())));
            }
        }
    }

    public static enum SaveOn {
        RELOAD,
        DISABLE,
        INTERVAL;


        @NotNull
        public static Optional<SaveOn> fromString(@Nullable String string) {
            if (string == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(SaveOn.valueOf(string.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }
}

