/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.script.CarpetScriptHost;
import carpet.script.Context;
import carpet.script.ScriptHost;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import net.replaceitem.discarpet.commands.DiscarpetCommand;
import net.replaceitem.discarpet.config.Bot;
import net.replaceitem.discarpet.config.BotConfig;
import net.replaceitem.discarpet.config.ConfigManager;
import net.replaceitem.discarpet.script.events.DiscordEvents;
import net.replaceitem.discarpet.script.events.MiscEvents;
import net.replaceitem.discarpet.script.util.EnumUtil;
import net.replaceitem.discarpet.script.util.Registration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Discarpet
implements CarpetExtension,
ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Discarpet");
    protected static ConfigManager configManager;
    public static Map<String, Bot> discordBots;

    public void onInitialize() {
        try {
            Path configDir = FabricLoader.getInstance().getConfigDir().normalize();
            Files.createDirectories(configDir, new FileAttribute[0]);
            File configFile = configDir.resolve("discarpet.json").normalize().toFile();
            configManager = new ConfigManager(configFile);
        }
        catch (IOException e) {
            LOGGER.error("Error loading Discarpet configuration file");
        }
        Discarpet.loadConfig(null);
        CarpetServer.manageExtension((CarpetExtension)this);
        LOGGER.info("Discarpet loaded");
    }

    public void onGameStarted() {
        DiscordEvents.noop();
        MiscEvents.noop();
        Registration.registerValueCasters();
        Registration.registerDiscordValues();
        Registration.registerMisc();
        Registration.registerFunctions();
        Registration.registerSchemas();
    }

    public void onServerClosed(MinecraftServer server) {
        LOGGER.info("Disconnecting all Discord bots");
        discordBots.forEach((s, bot) -> bot.disconnect());
    }

    public void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        DiscarpetCommand.register(dispatcher);
    }

    public static void loadConfig(class_2168 source) {
        boolean newlyCreatedConfig = configManager.loadAndUpdate();
        if (newlyCreatedConfig) {
            LOGGER.info("No Discarpet configuration file found, creating one. Edit config/discarpet.json to add your bots");
            return;
        }
        Discarpet.loadBots(source);
    }

    public static void loadBots(class_2168 source) {
        CompletableFuture.allOf((CompletableFuture[])discordBots.values().stream().map(bot -> bot == null ? null : bot.disconnect()).filter(Objects::nonNull).toArray(CompletableFuture[]::new));
        discordBots.clear();
        for (BotConfig botConfig : Discarpet.configManager.getConfig().BOTS) {
            if (botConfig == null) continue;
            String botId = botConfig.BOT_ID;
            try {
                Set<GatewayIntent> intents = botConfig.INTENTS.stream().map(s -> EnumUtil.getEnumOrThrow(GatewayIntent.class, s, "Unknown intent")).collect(Collectors.toSet());
                MemberCachePolicy memberCachePolicy = switch (botConfig.MEMBER_CACHE_POLICY.toLowerCase()) {
                    case "all" -> MemberCachePolicy.ALL;
                    case "online" -> MemberCachePolicy.ONLINE;
                    case "voice" -> MemberCachePolicy.VOICE;
                    case "pending" -> MemberCachePolicy.PENDING;
                    case "booster" -> MemberCachePolicy.BOOSTER;
                    case "owner" -> MemberCachePolicy.OWNER;
                    case "none" -> MemberCachePolicy.NONE;
                    default -> throw new IllegalArgumentException("Unknown member cache policy: " + botConfig.MEMBER_CACHE_POLICY);
                };
                CompletableFuture<Bot> botCompletableFuture = Bot.create(botId, botConfig.BOT_TOKEN, intents, memberCachePolicy);
                botCompletableFuture.exceptionally(throwable -> {
                    String error = "Could not login bot " + botId;
                    LOGGER.warn(error, throwable);
                    if (source != null) {
                        source.method_9226(() -> class_2561.method_43470((String)(error + ": " + throwable.getMessage())).method_27692(class_124.field_1061), false);
                    }
                    return null;
                });
                botCompletableFuture.thenAccept(bot -> {
                    if (bot == null) {
                        return;
                    }
                    discordBots.put(bot.getId(), (Bot)bot);
                    String msg = "Bot " + botId + " sucessfully logged in";
                    if (!intents.isEmpty()) {
                        msg = msg + " with intents " + intents.stream().map(Enum::toString).collect(Collectors.joining(","));
                    }
                    class_5250 text = class_2561.method_43470((String)msg).method_27694(style -> style.method_10977(class_124.field_1060));
                    if (source != null) {
                        source.method_9226(() -> text, false);
                    }
                    LOGGER.info(msg);
                });
            }
            catch (Exception e) {
                String error = "Could not create bot " + botId;
                LOGGER.warn(error, (Throwable)e);
                if (source == null) continue;
                source.method_9226(() -> class_2561.method_43470((String)(error + ": " + e.getMessage())).method_27692(class_124.field_1061), false);
            }
        }
    }

    public static boolean isScarpetGraphicsInstalled() {
        return FabricLoader.getInstance().isModLoaded("scarpet-graphics");
    }

    public static Bot getBotInContext(Context c, String source) {
        return Discarpet.getBotInHost(c.host, source);
    }

    public static Bot getBotInHost(ScriptHost h, String source) {
        Bot bot = Discarpet.getBotInHost(h);
        if (bot == null) {
            throw Discarpet.scarpetNoBotException(source);
        }
        return bot;
    }

    public static Bot getBotInHost(ScriptHost h) {
        if (h == null) {
            return null;
        }
        Value botKeyValue = (Value)((CarpetScriptHost)h).appConfig.get(StringValue.of((String)"bot"));
        if (botKeyValue == null) {
            return null;
        }
        String key = botKeyValue.getString();
        return discordBots.get(key);
    }

    public static InternalExpressionException scarpetNoBotException(String function) {
        return new InternalExpressionException(function + " requires a valid bot to be set in in the app config");
    }

    static {
        discordBots = Collections.synchronizedMap(new HashMap());
    }
}

