/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.config;

import java.time.Duration;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.replaceitem.discarpet.script.events.DiscarpetEventsListener;

public class Bot {
    private final JDA jda;
    private final String id;

    public JDA getJda() {
        return this.jda;
    }

    public String getId() {
        return this.id;
    }

    private static CompletableFuture<JDA> awaitReady(JDABuilder builder) {
        CompletableFuture<JDA> cf = new CompletableFuture<JDA>();
        Thread.startVirtualThread(() -> {
            try {
                cf.complete(builder.build().awaitReady());
            }
            catch (Exception e) {
                cf.completeExceptionally(e);
            }
        });
        return cf;
    }

    private static CompletableFuture<Void> awaitShutdown(JDA jda) {
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        Thread.startVirtualThread(() -> {
            try {
                jda.shutdown();
                jda.awaitShutdown(Duration.ofSeconds(5L));
                cf.complete(null);
            }
            catch (Exception e) {
                cf.completeExceptionally(e);
            }
        });
        return cf;
    }

    public static CompletableFuture<Bot> create(String id, String token, Set<GatewayIntent> intents, MemberCachePolicy memberCachePolicy) {
        CompletableFuture<JDA> cf = Bot.awaitReady(JDABuilder.createDefault((String)token).enableIntents(intents).setMemberCachePolicy(memberCachePolicy));
        cf.orTimeout(10L, TimeUnit.SECONDS);
        return cf.thenApply(jda -> new Bot(id, (JDA)jda));
    }

    public Bot(String id, JDA api) {
        this.id = id;
        this.jda = api;
        this.jda.addEventListener(new Object[]{new DiscarpetEventsListener(this)});
    }

    public String getInvite() {
        return this.jda.getInviteUrl(new Permission[0]);
    }

    public CompletableFuture<Void> disconnect() {
        return Bot.awaitShutdown(this.jda);
    }
}

