/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.replaceitem.discarpet.Discarpet;
import net.replaceitem.discarpet.config.Config;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected Config config;
    protected final File configFile;

    public ConfigManager(File configFile) {
        this.configFile = configFile;
    }

    public boolean loadAndUpdate() {
        boolean newlyCreated = this.load();
        this.config.fillDefaults();
        this.save();
        return newlyCreated;
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean load() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.configFile)));
            this.config = (Config)GSON.fromJson((Reader)reader, Config.class);
            return false;
        }
        catch (IOException e) {
            this.config = new Config();
            return true;
        }
    }

    public void save() {
        String jsonConfig = GSON.toJson((Object)this.config);
        try (FileWriter writer = new FileWriter(this.configFile);){
            writer.write(jsonConfig);
            writer.flush();
        }
        catch (IOException e) {
            Discarpet.LOGGER.error("Could not save config", (Throwable)e);
        }
    }
}

