/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.events;

import carpet.CarpetServer;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.events.guild.member.GuildMemberJoinEvent;
import net.dv8tion.jda.api.events.guild.member.GuildMemberRemoveEvent;
import net.dv8tion.jda.api.events.interaction.ModalInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.MessageContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.UserContextInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericComponentInteractionCreateEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericSelectMenuInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.MessageUpdateEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.minecraft.class_3738;
import net.replaceitem.discarpet.config.Bot;
import net.replaceitem.discarpet.script.events.DiscordEvents;
import org.jetbrains.annotations.NotNull;

public class DiscarpetEventsListener
extends ListenerAdapter {
    protected final Bot bot;

    public DiscarpetEventsListener(Bot bot) {
        this.bot = bot;
    }

    public void onMessageReceived(MessageReceivedEvent event) {
        Message message = event.getMessage();
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_MESSAGE.run(this.bot, message));
    }

    public void onMessageUpdate(MessageUpdateEvent event) {
        Message message = event.getMessage();
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_MESSAGE_EDIT.run(this.bot, message));
    }

    public void onMessageDelete(MessageDeleteEvent event) {
        String messageId = event.getMessageId();
        MessageChannelUnion channel = event.getChannel();
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_MESSAGE_DELETE.run(this.bot, messageId, channel));
    }

    public void onMessageReactionAdd(MessageReactionAddEvent event) {
        MessageReaction reaction = event.getReaction();
        event.retrieveMember().queue(member -> DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_REACTION.run(this.bot, reaction, (Member)member, true)));
    }

    public void onMessageReactionRemove(MessageReactionRemoveEvent event) {
        MessageReaction reaction = event.getReaction();
        event.retrieveMember().queue(member -> DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_REACTION.run(this.bot, reaction, (Member)member, false)));
    }

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_SLASH_COMMAND.run(this.bot, event));
    }

    public void onGenericComponentInteractionCreate(@NotNull GenericComponentInteractionCreateEvent event) {
        if (event instanceof ButtonInteractionEvent) {
            ButtonInteractionEvent buttonInteraction = (ButtonInteractionEvent)event;
            DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_BUTTON.run(this.bot, buttonInteraction));
        } else if (event instanceof GenericSelectMenuInteractionEvent) {
            GenericSelectMenuInteractionEvent selectMenuInteraction = (GenericSelectMenuInteractionEvent)event;
            DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_SELECT_MENU.run(this.bot, selectMenuInteraction));
        }
    }

    public void onModalInteraction(@NotNull ModalInteractionEvent event) {
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_MODAL.run(this.bot, event));
    }

    public void onMessageContextInteraction(@NotNull MessageContextInteractionEvent event) {
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_MESSAGE_CONTEXT_MENU.run(this.bot, event));
    }

    public void onUserContextInteraction(@NotNull UserContextInteractionEvent event) {
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_USER_CONTEXT_MENU.run(this.bot, event));
    }

    public void onGuildMemberJoin(@NotNull GuildMemberJoinEvent event) {
        Guild guild = event.getGuild();
        Member member = event.getMember();
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_SERVER_MEMBER_JOIN.run(this.bot, guild, member));
    }

    public void onGuildMemberRemove(@NotNull GuildMemberRemoveEvent event) {
        Guild guild = event.getGuild();
        User user = event.getUser();
        DiscarpetEventsListener.callEventOnGameThread(() -> DiscordEvents.DISCORD_SERVER_MEMBER_LEAVE.run(this.bot, guild, user));
    }

    private static void callEventOnGameThread(Runnable runnable) {
        if (CarpetServer.minecraft_server == null) {
            return;
        }
        class_3738 serverTask = new class_3738(Integer.MIN_VALUE, runnable);
        CarpetServer.minecraft_server.method_63588((Runnable)serverTask);
    }
}

