/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.exception;

import carpet.script.api.Auxiliary;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.exceptions.HttpException;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.exceptions.RateLimitedException;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.Response;
import net.replaceitem.discarpet.Discarpet;
import net.replaceitem.discarpet.script.util.MapBuilder;
import net.replaceitem.discarpet.script.util.ValueUtil;
import org.jetbrains.annotations.Nullable;

public class DiscordThrowables {
    public static final Throwables DISCORD_EXCEPTION = Throwables.register((String)"discord_exception", (Throwables)Throwables.THROWN_EXCEPTION_TYPE);
    public static final Throwables API_EXCEPTION = Throwables.register((String)"api_exception", (Throwables)DISCORD_EXCEPTION);
    public static final Throwables RATE_LIMIT = Throwables.register((String)"rate_limit", (Throwables)DISCORD_EXCEPTION);
    public static final Throwables MISSING_PERMISSION = Throwables.register((String)"missing_permission", (Throwables)DISCORD_EXCEPTION);
    public static final Throwables HTTP_EXCEPTION = Throwables.register((String)"http_exception", (Throwables)DISCORD_EXCEPTION);

    public static ThrowStatement convert(Throwable exception) {
        return DiscordThrowables.convert(exception, null);
    }

    public static ThrowStatement convert(Throwable exception, @Nullable String message) {
        String finalMessage = message == null ? exception.getMessage() : exception.getMessage() + ": " + message;
        Throwable throwable = exception;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecutionException.class, ErrorResponseException.class, PermissionException.class, RateLimitedException.class, HttpException.class, IOException.class, UncheckedIOException.class}, (Object)throwable2, n)) {
                case 0: {
                    ExecutionException executionException = (ExecutionException)throwable2;
                    if (executionException.getCause() == null) {
                        n = 1;
                        continue block9;
                    }
                    return DiscordThrowables.convert(executionException.getCause(), message);
                }
                case 1: {
                    ErrorResponseException errorResponseException = (ErrorResponseException)throwable2;
                    MapValue value = DiscordThrowables.createErrorMap(errorResponseException.getResponse());
                    return new ThrowStatement((Value)value, API_EXCEPTION);
                }
                case 2: {
                    PermissionException permissionException = (PermissionException)throwable2;
                    MapBuilder map = new MapBuilder().put("permission", ValueUtil.ofEnum(permissionException.getPermission())).put("message", permissionException.getMessage());
                    if (permissionException instanceof InsufficientPermissionException) {
                        InsufficientPermissionException insufficientPermissionException = (InsufficientPermissionException)permissionException;
                        map.put("server", Long.toUnsignedString(insufficientPermissionException.getGuildId()));
                        map.put("channel", Long.toUnsignedString(insufficientPermissionException.getChannelId()));
                    }
                    return new ThrowStatement((Value)map.build(), MISSING_PERMISSION);
                }
                case 3: {
                    RateLimitedException ignored = (RateLimitedException)throwable2;
                    return new ThrowStatement(finalMessage, RATE_LIMIT);
                }
                case 4: {
                    HttpException ignored = (HttpException)throwable2;
                    return new ThrowStatement(finalMessage, HTTP_EXCEPTION);
                }
                case 5: {
                    IOException ignored = (IOException)throwable2;
                    return new ThrowStatement(finalMessage, Throwables.IO_EXCEPTION);
                }
                case 6: {
                    UncheckedIOException uncheckedIOException = (UncheckedIOException)throwable2;
                    if (uncheckedIOException.getCause() == null) {
                        n = 7;
                        continue block9;
                    }
                    return DiscordThrowables.convert(uncheckedIOException.getCause(), message);
                }
            }
            break;
        }
        Discarpet.LOGGER.error("Could not convert exception type {} to discarpet exception ({}):", (Object)exception.getClass().getSimpleName(), (Object)message, (Object)exception);
        return new ThrowStatement(exception.getMessage(), Throwables.THROWN_EXCEPTION_TYPE);
    }

    public static ThrowStatement genericCode(ErrorResponse errorCode) {
        return new ThrowStatement((Value)DiscordThrowables.createSimpleError(errorCode), DISCORD_EXCEPTION);
    }

    public static ThrowStatement genericMessage(String message) {
        return new ThrowStatement(message, DISCORD_EXCEPTION);
    }

    private static MapValue createSimpleError(ErrorResponse errorCode) {
        return new MapBuilder().put("code", NumericValue.of((Number)errorCode.getCode())).put("message", StringValue.of((String)errorCode.getMeaning())).build();
    }

    private static MapValue createErrorMap(Response response) {
        MapBuilder map = new MapBuilder().put("code", NumericValue.of((Number)response.code)).put("message", StringValue.of((String)DiscordThrowables.getMessage(response)));
        response.optObject().ifPresent(body -> {
            Value json;
            try {
                json = (Value)Auxiliary.GSON.fromJson(body.toString(), Value.class);
            }
            catch (JsonParseException e) {
                json = StringValue.of((String)body.toString());
            }
            map.put("body", json);
        });
        return map.build();
    }

    private static String getMessage(Response response) {
        return Objects.equals(response.message, "ERROR") && response.getException() != null ? response.getException().getMessage() : response.message;
    }
}

