/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.functions;

import carpet.script.Context;
import carpet.script.annotation.ScarpetFunction;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.managers.WebhookManager;
import net.dv8tion.jda.api.managers.channel.ChannelManager;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.restaction.ThreadChannelAction;
import net.dv8tion.jda.api.requests.restaction.WebhookAction;
import net.dv8tion.jda.internal.entities.channel.mixin.attribute.IThreadContainerMixin;
import net.dv8tion.jda.internal.entities.channel.mixin.attribute.IWebhookContainerMixin;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.schema.Parser;
import net.replaceitem.discarpet.script.schema.schemas.ChannelUpdaterSchema;
import net.replaceitem.discarpet.script.schema.schemas.ThreadSchema;
import net.replaceitem.discarpet.script.schema.schemas.webhooks.WebhookProfileSchema;
import net.replaceitem.discarpet.script.schema.schemas.webhooks.WebhookProfileUpdaterSchema;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.ChannelValue;
import net.replaceitem.discarpet.script.values.MessageValue;

public class Channels {
    @ScarpetFunction
    public void dc_update_channel(Context context, Channel channel, Value channelUpdater) {
        try {
            ChannelUpdaterSchema channelUpdaterSchema = Parser.parseType(context, channelUpdater, ChannelUpdaterSchema.class);
            if (!(channel instanceof GuildChannel)) {
                throw DiscordThrowables.genericMessage("Can only update server channels");
            }
            GuildChannel guildChannel = (GuildChannel)channel;
            ChannelManager manager = guildChannel.getManager();
            channelUpdaterSchema.apply(manager);
            ValueUtil.awaitRest(manager, "Error updating channel");
        }
        catch (InsufficientPermissionException e) {
            throw DiscordThrowables.convert(e);
        }
    }

    @ScarpetFunction
    public WebhookClient<?> dc_create_webhook(Context context, Channel channel, Value webhookBuilder) {
        if (!(channel instanceof IWebhookContainerMixin)) {
            return null;
        }
        IWebhookContainerMixin webhookContainer = (IWebhookContainerMixin)channel;
        WebhookAction webhookAction = webhookContainer.createWebhook("Webhook");
        Parser.parseType(context, webhookBuilder, WebhookProfileSchema.class).apply(webhookAction);
        return (WebhookClient)ValueUtil.awaitRest(webhookAction, "Error creating webhook");
    }

    @ScarpetFunction
    public void dc_update_webhook(Context context, WebhookClient<Message> webhookClient, Value webhookBuilder) {
        try {
            if (!(webhookClient instanceof Webhook)) {
                throw new ThrowStatement("Cannot update webhook not managed by this bot", DiscordThrowables.DISCORD_EXCEPTION);
            }
            Webhook webhook = (Webhook)webhookClient;
            WebhookManager manager = webhook.getManager();
            Parser.parseType(context, webhookBuilder, WebhookProfileUpdaterSchema.class).apply(manager);
            ValueUtil.awaitRest(manager, "Error updating webhook");
        }
        catch (InsufficientPermissionException e) {
            throw DiscordThrowables.convert(e);
        }
    }

    @ScarpetFunction
    public Channel dc_create_thread(Context context, Value channelOrMessage, Value threadValue) {
        if (channelOrMessage instanceof ChannelValue) {
            ChannelValue channelValue = (ChannelValue)channelOrMessage;
            Object t = channelValue.getDelegate();
            if (!(t instanceof IThreadContainerMixin)) {
                throw DiscordThrowables.genericCode(ErrorResponse.INVALID_CHANNEL_TYPE);
            }
            IThreadContainerMixin threadContainerMixin = (IThreadContainerMixin)t;
            ThreadChannelAction action = Parser.parseType(context, threadValue, ThreadSchema.class).apply(threadContainerMixin);
            return (Channel)ValueUtil.awaitRest(action, "Error creating thread channel");
        }
        if (channelOrMessage instanceof MessageValue) {
            MessageValue messageValue = (MessageValue)channelOrMessage;
            ThreadChannelAction action = Parser.parseType(context, threadValue, ThreadSchema.class).apply((Message)messageValue.getDelegate());
            return (Channel)ValueUtil.awaitRest(action, "Error creating thread channel");
        }
        throw new InternalExpressionException("Expected a message or channel as the first parameter");
    }
}

