/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.functions;

import carpet.script.annotation.ScarpetFunction;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.util.ValueUtil;

public class Users {
    @ScarpetFunction(maxParams=4)
    public void dc_set_nickname(User user, Guild server, String name, String ... reason) {
        Member member = server.getMember((UserSnowflake)user);
        if (member == null) {
            throw DiscordThrowables.genericMessage("Unknown member");
        }
        ValueUtil.awaitRest(server.modifyNickname(member, name).reason(ValueUtil.optionalArg(reason)), "Error updating nickname");
    }

    @ScarpetFunction(maxParams=3)
    public void dc_add_role(User user, Role role, String ... reason) {
        Member member = role.getGuild().getMember((UserSnowflake)user);
        if (member == null) {
            throw DiscordThrowables.genericMessage("Unknown member");
        }
        ValueUtil.awaitRest(role.getGuild().addRoleToMember((UserSnowflake)user, role).reason(ValueUtil.optionalArg(reason)), "Could not add role to user");
    }

    @ScarpetFunction(maxParams=3)
    public void dc_remove_role(User user, Role role, String ... reason) {
        Member member = role.getGuild().getMember((UserSnowflake)user);
        if (member == null) {
            throw DiscordThrowables.genericMessage("Unknown member");
        }
        ValueUtil.awaitRest(role.getGuild().removeRoleFromMember((UserSnowflake)user, role).reason(ValueUtil.optionalArg(reason)), "Could not remove role to user");
    }

    @ScarpetFunction(maxParams=4)
    public void dc_set_timeout(User user, Guild server, long epochMilli, Optional<String> reason) {
        ValueUtil.awaitRest(server.timeoutUntil((UserSnowflake)user, (TemporalAccessor)Instant.ofEpochMilli(epochMilli)), "Could not timeout user");
    }
}

