/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.functions;

import carpet.script.annotation.ScarpetFunction;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.Value;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.Renamable;

public class Util {
    @ScarpetFunction(maxParams=2)
    public void dc_delete(Value value, String ... reason) {
        if (!(value instanceof Deletable)) {
            throw new InternalExpressionException(value.getTypeString() + " is not deletable");
        }
        Deletable deletable = (Deletable)value;
        RestAction<?> restAction = deletable.delete(ValueUtil.optionalArg(reason));
        ValueUtil.awaitRest(restAction, "Failed to delete " + value.getTypeString());
    }

    @ScarpetFunction
    public void dc_set_name(Value value, String name) {
        if (!(value instanceof Renamable)) {
            throw new InternalExpressionException(value.getTypeString() + " is not renamable");
        }
        Renamable renamable = (Renamable)value;
        RestAction<?> rename = renamable.rename(name);
        ValueUtil.awaitRest(rename, "Failed to rename " + value.getTypeString());
    }
}

