/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema;

import carpet.script.Context;
import carpet.script.annotation.SimpleTypeConverter;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.lang.reflect.AccessFlag;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.replaceitem.discarpet.Discarpet;
import net.replaceitem.discarpet.mixins.SimpleTypeConverterAccessor;
import net.replaceitem.discarpet.script.schema.DirectParsable;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.Redirector;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.SchemaConstructor;
import net.replaceitem.discarpet.script.util.EnumUtil;
import net.replaceitem.discarpet.script.util.MapValueUtil;

public class Parser {
    private static final Map<Class<?>, Class<?>> schemaClasses = new HashMap();

    public static void registerSchema(Class<?> schemaClass) {
        Class<?> resultClass = Parser.getResultClassFromGeneric(schemaClass);
        if (resultClass == null) {
            Discarpet.LOGGER.error("Error finding the result class for '{}' class", (Object)Parser.getClassName(schemaClass));
        }
        schemaClasses.put(resultClass, schemaClass);
    }

    private static boolean hasRegisteredParser(Class<?> resultClass) {
        return schemaClasses.containsKey(resultClass);
    }

    public static <T> T parseType(Context context, Value value, Class<T> resultClass) {
        return Parser.parseType(context, value, resultClass, Parser.getClassName(resultClass));
    }

    public static <T, E extends Enum<E>> T parseType(Context context, Value value, Class<T> resultClass, String name) {
        Object converted;
        if (Value.class.isAssignableFrom(resultClass)) {
            if (resultClass == Value.class) {
                return (T)value;
            }
            if (resultClass.isInstance(value)) {
                return (T)value;
            }
            throw new InternalExpressionException("Expected a " + resultClass.getSimpleName() + " value, but got a " + value.getTypeString());
        }
        if (resultClass.isEnum()) {
            return Parser.parseEnum(value, resultClass, name);
        }
        SimpleTypeConverter<Value, T> typeConverter = SimpleTypeConverterAccessor.callGet(resultClass);
        if (typeConverter != null && (converted = typeConverter.convert(value, null)) != null) {
            return (T)converted;
        }
        T primitive = Parser.tryParsePrimitive(value, resultClass, name);
        if (primitive != null) {
            return primitive;
        }
        Class<?> schemaClass = schemaClasses.get(resultClass);
        if (schemaClass != null) {
            if (SchemaConstructor.class.isAssignableFrom(schemaClass)) {
                if (!Parser.hasRegisteredParser(resultClass)) {
                    throw new InternalExpressionException("Could not parse " + name + ", since there was no registered parser");
                }
                Object parsedValue = Parser.callConstructor(schemaClass, name);
                Object directlyCreated = ((SchemaConstructor)parsedValue).tryCreateFromValueDirectly(value);
                if (directlyCreated != null) {
                    return directlyCreated;
                }
                SchemaConstructor schema = (SchemaConstructor)Parser.parseSchemaType(context, value, parsedValue, schemaClass, name);
                try {
                    return schema.construct(context);
                }
                catch (Exception e) {
                    Parser.rethrowUserException(e);
                    throw new InternalExpressionException("Could not parse " + name + ":\n" + e.getMessage());
                }
            }
            if (Redirector.class.isAssignableFrom(schemaClass)) {
                Object parsedValue = Parser.callConstructor(schemaClass, name);
                return (T)Parser.parseSchemaType(context, value, parsedValue, schemaClass, name);
            }
        }
        if (resultClass.getAnnotation(SchemaClass.class) == null) {
            throw new IllegalArgumentException("Class " + String.valueOf(resultClass) + " is neither a schema class or has a schema class registered.");
        }
        T parsedValue = Parser.callConstructor(resultClass, name);
        return Parser.parseSchemaType(context, value, parsedValue, resultClass, name);
    }

    private static <T> T tryParsePrimitive(Value value, Class<T> schemaClass, String name) {
        if (schemaClass == Integer.class) {
            if (!(value instanceof NumericValue)) {
                throw new InternalExpressionException("'" + name + "' value needs to be a number");
            }
            NumericValue numericValue = (NumericValue)value;
            return schemaClass.cast(numericValue.getInt());
        }
        if (schemaClass == Boolean.class) {
            return schemaClass.cast(value.getBoolean());
        }
        if (schemaClass == Double.class) {
            if (!(value instanceof NumericValue)) {
                throw new InternalExpressionException("'" + name + "' value needs to be a number");
            }
            NumericValue numericValue = (NumericValue)value;
            return schemaClass.cast(numericValue.getDouble());
        }
        if (schemaClass == Float.class) {
            if (!(value instanceof NumericValue)) {
                throw new InternalExpressionException("'" + name + "' value needs to be a number");
            }
            NumericValue numericValue = (NumericValue)value;
            return schemaClass.cast(Float.valueOf(numericValue.getFloat()));
        }
        if (schemaClass == Long.class) {
            if (!(value instanceof NumericValue)) {
                throw new InternalExpressionException("'" + name + "' value needs to be a number");
            }
            NumericValue numericValue = (NumericValue)value;
            return schemaClass.cast(numericValue.getLong());
        }
        if (schemaClass == String.class) {
            return schemaClass.cast(value.getString());
        }
        return null;
    }

    public static <T> T parseSchemaType(Context context, Value value, T object, Class<T> schemaClass, String name) {
        try {
            DirectParsable directParsable;
            T parsedObject = object instanceof DirectParsable && (directParsable = (DirectParsable)object).tryParseDirectly(value, context) ? object : schemaClass.cast(Parser.parseClass(context, value, schemaClass));
            if (Redirector.class.isAssignableFrom(schemaClass)) {
                Class redirectedClass = ((Redirector)parsedObject).redirect();
                return Parser.parseType(context, value, redirectedClass);
            }
            return parsedObject;
        }
        catch (Exception e) {
            Parser.rethrowUserException(e);
            throw new InternalExpressionException("Could not parse '" + name + "' as '" + Parser.getClassName(schemaClass) + "':\n" + e.getMessage());
        }
    }

    public static <T> T parseClass(Context context, Value value, Class<T> schemaClass) {
        SchemaClass schemaClassAnnotation = Parser.getRequiredSchemaClassAnnotation(schemaClass);
        String name = schemaClassAnnotation.name();
        if (!(value instanceof MapValue)) {
            throw new InternalExpressionException("Could not parse " + name + ", value needs to be a map");
        }
        MapValue mapValue = (MapValue)value;
        Map map = mapValue.getMap();
        Field[] declaredFields = schemaClass.getDeclaredFields();
        T parsedValue = Parser.callConstructor(schemaClass, name);
        for (Field field : declaredFields) {
            if (field.accessFlags().contains((Object)AccessFlag.PRIVATE)) continue;
            Parser.assignField(context, map, field, parsedValue);
        }
        return parsedValue;
    }

    private static <T> T callConstructor(Class<T> clazz, String name) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Could not parse " + name + ":\n" + e.getMessage());
        }
    }

    private static <E extends Enum<E>> E parseEnum(Value value, Class<E> resultClass, String name) {
        String enumValue = value.getString();
        return EnumUtil.getEnumOrThrow(resultClass, enumValue, "Invalid value for '" + name + "'");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void assignField(Context context, Map<Value, Value> map, Field field, Object parsedValue) {
        String name = field.getName();
        Class<?> fieldType = field.getType();
        OptionalField optionalFieldAnnotation = field.getAnnotation(OptionalField.class);
        boolean required = optionalFieldAnnotation == null;
        try {
            void var8_18;
            Value value = MapValueUtil.getValueInMap(map, name, required);
            if (value == null) return;
            if (fieldType == List.class) {
                ParameterizedType parameterizedType;
                if (!(value instanceof ListValue)) {
                    throw new InternalExpressionException("'" + name + "' value needs to be a list");
                }
                ListValue listValue = (ListValue)value;
                Type generic = Parser.getListType(field);
                if (generic instanceof ParameterizedType && (parameterizedType = (ParameterizedType)generic).getRawType() == List.class) {
                    Type actualGenericType = Parser.getActualGenericType(parameterizedType);
                    if (actualGenericType == null) {
                        throw new InternalExpressionException("No type argument on list");
                    }
                    if (!(actualGenericType instanceof Class)) {
                        throw new InternalExpressionException("Invalid type argument on list: " + String.valueOf(actualGenericType));
                    }
                    Class clazz = (Class)actualGenericType;
                    List list = Parser.parse2DList(context, listValue.getItems(), clazz, name);
                } else {
                    if (!(generic instanceof Class)) throw new InternalExpressionException("Invalid type parameter provided for field " + name);
                    Class clazz = (Class)generic;
                    List list = Parser.parseList(context, listValue.getItems(), clazz, name);
                }
            } else {
                Object obj = Parser.parseType(context, value, fieldType, name);
            }
            field.setAccessible(true);
            field.set(parsedValue, var8_18);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalExpressionException("Could not assign field '" + name + "':\n" + illegalAccessException.getMessage());
        }
    }

    private static <T> List<T> parseList(Context context, List<Value> list, Class<T> generic, String name) {
        ArrayList<T> parsedList = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Value value = list.get(i);
                T element = Parser.parseType(context, value, generic, generic.getSimpleName());
                parsedList.add(element);
                continue;
            }
            catch (Exception e) {
                Parser.rethrowUserException(e);
                throw new InternalExpressionException("Could not parse value in '" + name + "' list with index " + i + ":\n" + e.getMessage());
            }
        }
        return parsedList;
    }

    private static <T> List<List<T>> parse2DList(Context context, List<Value> list, Class<T> generic, String name) {
        ArrayList<List<T>> parsedList = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Value value = list.get(i);
                if (!(value instanceof ListValue)) {
                    throw new InternalExpressionException("Item in " + name + " list needs to be a list");
                }
                ListValue listValue = (ListValue)value;
                List<T> element = Parser.parseList(context, listValue.getItems(), generic, name);
                parsedList.add(element);
                continue;
            }
            catch (Exception e) {
                Parser.rethrowUserException(e);
                throw new InternalExpressionException("Could not parse value in '" + name + "' list with index " + i + ":\n" + e.getMessage());
            }
        }
        return parsedList;
    }

    private static Class<?> getResultClassFromGeneric(Class<?> clazz) {
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        if (genericInterfaces.length == 0) {
            return null;
        }
        Type genericInterface = genericInterfaces[0];
        Type actualGenericType = Parser.getActualGenericType(genericInterface);
        if (actualGenericType instanceof Class) {
            Class genericClass = (Class)actualGenericType;
            return genericClass;
        }
        return null;
    }

    private static Type getListType(Field field) {
        Type genericType = field.getGenericType();
        return Parser.getActualGenericType(genericType);
    }

    public static Type getActualGenericType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return null;
        }
        return actualTypeArguments[0];
    }

    private static SchemaClass getRequiredSchemaClassAnnotation(Class<?> schemaClass) {
        SchemaClass schemaClassAnnotation = schemaClass.getAnnotation(SchemaClass.class);
        if (schemaClassAnnotation == null) {
            throw new InternalExpressionException("Trying to parse class " + schemaClass.getSimpleName() + " without @SchemaClass annotation");
        }
        return schemaClassAnnotation;
    }

    public static String getClassName(Class<?> clazz) {
        if (schemaClasses.containsKey(clazz)) {
            clazz = schemaClasses.get(clazz);
        }
        if (!clazz.isAnnotationPresent(SchemaClass.class)) {
            return clazz.getSimpleName();
        }
        SchemaClass schemaClassAnnotation = Parser.getRequiredSchemaClassAnnotation(clazz);
        return schemaClassAnnotation.name();
    }

    private static void rethrowUserException(Exception e) throws ThrowStatement {
        if (e instanceof ThrowStatement) {
            ThrowStatement throwStatement = (ThrowStatement)e;
            throw throwStatement;
        }
    }
}

