/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas;

import java.util.EnumSet;
import java.util.List;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.SchemaClass;

@SchemaClass(name="allowed_mentions")
public class AllowedMentionsSchema {
    @OptionalField
    Boolean mention_roles = false;
    @OptionalField
    Boolean mention_users = false;
    @OptionalField
    Boolean mention_channels = false;
    @OptionalField
    Boolean mention_emojis = false;
    @OptionalField
    Boolean mention_slash_commands = false;
    @OptionalField
    Boolean mention_here = false;
    @OptionalField
    Boolean mention_everyone = false;
    @OptionalField
    Boolean mention_replied_user = false;
    @OptionalField
    List<String> roles = List.of();
    @OptionalField
    List<String> users = List.of();

    public void apply(MessageRequest<?> messageRequest) {
        EnumSet<Message.MentionType> mentionTypes = EnumSet.noneOf(Message.MentionType.class);
        if (this.mention_roles.booleanValue()) {
            mentionTypes.add(Message.MentionType.ROLE);
        }
        if (this.mention_users.booleanValue()) {
            mentionTypes.add(Message.MentionType.USER);
        }
        if (this.mention_channels.booleanValue()) {
            mentionTypes.add(Message.MentionType.CHANNEL);
        }
        if (this.mention_emojis.booleanValue()) {
            mentionTypes.add(Message.MentionType.EMOJI);
        }
        if (this.mention_slash_commands.booleanValue()) {
            mentionTypes.add(Message.MentionType.SLASH_COMMAND);
        }
        if (this.mention_here.booleanValue()) {
            mentionTypes.add(Message.MentionType.HERE);
        }
        if (this.mention_everyone.booleanValue()) {
            mentionTypes.add(Message.MentionType.EVERYONE);
        }
        messageRequest.setAllowedMentions(mentionTypes);
        messageRequest.mentionRepliedUser(this.mention_replied_user.booleanValue());
        if (this.roles != null) {
            messageRequest.mentionRoles(this.roles);
        }
        if (this.users != null) {
            messageRequest.mentionRoles(this.users);
        }
    }
}

