/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas;

import carpet.script.exception.InternalExpressionException;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.attribute.IPostContainer;
import net.dv8tion.jda.api.entities.channel.concrete.Category;
import net.dv8tion.jda.api.entities.channel.concrete.ThreadChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.managers.channel.ChannelManager;
import net.dv8tion.jda.api.managers.channel.attribute.IAgeRestrictedChannelManager;
import net.dv8tion.jda.api.managers.channel.attribute.ICategorizableChannelManager;
import net.dv8tion.jda.api.managers.channel.attribute.IPositionableChannelManager;
import net.dv8tion.jda.api.managers.channel.attribute.IPostContainerManager;
import net.dv8tion.jda.api.managers.channel.attribute.ISlowmodeChannelManager;
import net.dv8tion.jda.api.managers.channel.attribute.IThreadContainerManager;
import net.dv8tion.jda.api.managers.channel.concrete.ThreadChannelManager;
import net.dv8tion.jda.api.managers.channel.middleman.AudioChannelManager;
import net.dv8tion.jda.api.managers.channel.middleman.StandardGuildMessageChannelManager;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="channel_updater")
public class ChannelUpdaterSchema {
    @OptionalField
    @Nullable
    String name;
    @OptionalField
    @Nullable
    String topic;
    @OptionalField
    @Nullable
    Boolean nsfw;
    @OptionalField
    @Nullable
    Integer position;
    @OptionalField
    @Nullable
    Channel parent;
    @OptionalField
    @Nullable
    Integer auto_archive_duration;
    @OptionalField
    @Nullable
    Integer slowmode;
    @OptionalField
    @Nullable
    Boolean archived;
    @OptionalField
    @Nullable
    Boolean locked;
    @OptionalField
    @Nullable
    Boolean invitable;
    @OptionalField
    @Nullable
    Boolean pinned;
    @OptionalField
    @Nullable
    Integer default_threads_slowmode;
    @OptionalField
    @Nullable
    Boolean tag_required;
    @OptionalField
    @Nullable
    IPostContainer.SortOrder default_sort_order;
    @OptionalField
    @Nullable
    Emoji default_reaction;
    @OptionalField
    @Nullable
    Integer bitrate;
    @OptionalField
    @Nullable
    Integer user_limit;
    @OptionalField
    @Nullable
    String reason;

    public void apply(ChannelManager<?, ?> manager) {
        AudioChannelManager audioChannelManager;
        ThreadChannelManager threadChannelManager;
        IPostContainerManager postContainerManager;
        if (this.name != null) {
            manager.setName(this.name);
        }
        if (this.topic != null) {
            if (manager instanceof StandardGuildMessageChannelManager) {
                StandardGuildMessageChannelManager standardGuildMessageChannelManager = (StandardGuildMessageChannelManager)manager;
                standardGuildMessageChannelManager.setTopic(this.topic);
            } else if (manager instanceof IPostContainerManager) {
                postContainerManager = (IPostContainerManager)manager;
                postContainerManager.setTopic(this.topic);
            } else {
                throw ChannelUpdaterSchema.wrongType("topic", manager);
            }
        }
        if (this.nsfw != null) {
            if (manager instanceof IAgeRestrictedChannelManager) {
                IAgeRestrictedChannelManager ageRestrictedChannelManager = (IAgeRestrictedChannelManager)manager;
                ageRestrictedChannelManager.setNSFW(this.nsfw.booleanValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("nsfw", manager);
            }
        }
        if (this.position != null) {
            if (manager instanceof IPositionableChannelManager) {
                IPositionableChannelManager positionableChannelManager = (IPositionableChannelManager)manager;
                positionableChannelManager.setPosition(this.position.intValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("position", manager);
            }
        }
        if (this.parent != null) {
            if (manager instanceof ICategorizableChannelManager) {
                ICategorizableChannelManager iCategorizableChannelManager = (ICategorizableChannelManager)manager;
                Channel channel = this.parent;
                if (!(channel instanceof Category)) {
                    throw new InternalExpressionException("'parent' must be a channel category");
                }
                Category category = (Category)channel;
                iCategorizableChannelManager.setParent(category);
            } else {
                throw ChannelUpdaterSchema.wrongType("parent", manager);
            }
        }
        if (this.slowmode != null) {
            if (manager instanceof ISlowmodeChannelManager) {
                ISlowmodeChannelManager slowmodeChannelManager = (ISlowmodeChannelManager)manager;
                slowmodeChannelManager.setSlowmode(this.slowmode.intValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("slowmode", manager);
            }
        }
        if (this.auto_archive_duration != null) {
            if (manager instanceof ThreadChannelManager) {
                threadChannelManager = (ThreadChannelManager)manager;
                threadChannelManager.setAutoArchiveDuration(ThreadChannel.AutoArchiveDuration.fromKey((int)this.auto_archive_duration));
            } else {
                throw ChannelUpdaterSchema.wrongType("auto_archive_duration", manager);
            }
        }
        if (this.archived != null) {
            if (manager instanceof ThreadChannelManager) {
                threadChannelManager = (ThreadChannelManager)manager;
                threadChannelManager.setArchived(this.archived.booleanValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("archived", manager);
            }
        }
        if (this.locked != null) {
            if (manager instanceof ThreadChannelManager) {
                threadChannelManager = (ThreadChannelManager)manager;
                threadChannelManager.setLocked(this.locked.booleanValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("locked", manager);
            }
        }
        if (this.invitable != null) {
            if (manager instanceof ThreadChannelManager) {
                threadChannelManager = (ThreadChannelManager)manager;
                threadChannelManager.setInvitable(this.invitable.booleanValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("invitable", manager);
            }
        }
        if (this.pinned != null) {
            if (manager instanceof ThreadChannelManager) {
                threadChannelManager = (ThreadChannelManager)manager;
                threadChannelManager.setInvitable(this.pinned.booleanValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("pinned", manager);
            }
        }
        if (this.default_threads_slowmode != null) {
            if (manager instanceof IThreadContainerManager) {
                IThreadContainerManager threadContainerManager = (IThreadContainerManager)manager;
                threadContainerManager.setDefaultThreadSlowmode(this.default_threads_slowmode.intValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("default_threads_slowmode", manager);
            }
        }
        if (this.tag_required != null) {
            if (manager instanceof IPostContainerManager) {
                postContainerManager = (IPostContainerManager)manager;
                postContainerManager.setTagRequired(this.tag_required.booleanValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("tag_required", manager);
            }
        }
        if (this.default_sort_order != null) {
            if (manager instanceof IPostContainerManager) {
                postContainerManager = (IPostContainerManager)manager;
                postContainerManager.setDefaultSortOrder(this.default_sort_order);
            } else {
                throw ChannelUpdaterSchema.wrongType("default_sort_order", manager);
            }
        }
        if (this.default_reaction != null) {
            if (manager instanceof IPostContainerManager) {
                postContainerManager = (IPostContainerManager)manager;
                postContainerManager.setDefaultReaction(this.default_reaction);
            } else {
                throw ChannelUpdaterSchema.wrongType("default_reaction", manager);
            }
        }
        if (this.bitrate != null) {
            if (manager instanceof AudioChannelManager) {
                audioChannelManager = (AudioChannelManager)manager;
                audioChannelManager.setBitrate(this.bitrate.intValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("bitrate", manager);
            }
        }
        if (this.user_limit != null) {
            if (manager instanceof AudioChannelManager) {
                audioChannelManager = (AudioChannelManager)manager;
                audioChannelManager.setUserLimit(this.user_limit.intValue());
            } else {
                throw ChannelUpdaterSchema.wrongType("user_limit", manager);
            }
        }
        manager.reason(this.reason);
    }

    private static InternalExpressionException wrongType(String fieldName, ChannelManager<?, ?> manager) {
        return new InternalExpressionException("'" + fieldName + "' is not supported for channel of type " + manager.getChannel().getType().name().toLowerCase());
    }
}

