/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas;

import carpet.script.Context;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.awt.Color;
import java.util.List;
import net.replaceitem.discarpet.script.schema.DirectParsable;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.SchemaConstructor;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="color")
public class ColorSchema
implements SchemaConstructor<Color>,
DirectParsable {
    Integer r;
    Integer g;
    Integer b;

    @Override
    public boolean tryParseDirectly(Value value, Context context) {
        if (value instanceof ListValue) {
            ListValue listValue = (ListValue)value;
            List list = listValue.getItems();
            if (list.size() != 3) {
                throw new InternalExpressionException("Color list needs to a list with length 3 [r,g,b]");
            }
            this.r = NumericValue.asNumber((Value)((Value)list.get(0)), (String)"r").getInt();
            this.g = NumericValue.asNumber((Value)((Value)list.get(1)), (String)"g").getInt();
            this.b = NumericValue.asNumber((Value)((Value)list.get(2)), (String)"b").getInt();
            return true;
        }
        return false;
    }

    @Override
    public Color construct(Context context) {
        return new Color(this.r, this.g, this.b);
    }

    @Override
    @Nullable
    public Color tryCreateFromValueDirectly(Value value) {
        if (value instanceof NumericValue) {
            NumericValue numericValue = (NumericValue)value;
            return new Color(numericValue.getInt());
        }
        return null;
    }
}

