/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas;

import carpet.script.Context;
import carpet.script.argument.FileArgument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.utils.FileUpload;
import net.replaceitem.discarpet.Discarpet;
import net.replaceitem.discarpet.script.schema.DirectParsable;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.SchemaConstructor;
import net.replaceitem.discarpet.script.util.FileUtil;
import net.replaceitem.discarpet.script.util.ScarpetGraphicsDependency;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="file")
public class FileSchema
implements SchemaConstructor<AbstractFile>,
DirectParsable {
    @OptionalField
    @Nullable
    String file;
    @OptionalField
    Boolean file_shared = false;
    @OptionalField
    @Nullable
    String url;
    @OptionalField
    @Nullable
    String string;
    @OptionalField
    @Nullable
    String base64;
    @OptionalField
    @Nullable
    Value image;
    @OptionalField
    @Nullable
    String image_type;

    private void validateFields() {
        ArrayList<String> fields = new ArrayList<String>(5);
        if (this.file != null) {
            fields.add("file");
        }
        if (this.url != null) {
            fields.add("url");
        }
        if (this.string != null) {
            fields.add("string");
        }
        if (this.base64 != null) {
            fields.add("base64");
        }
        if (this.image != null) {
            fields.add("image");
        }
        if (fields.isEmpty()) {
            throw new InternalExpressionException("Expected either 'file', 'url', 'image', 'base64' or 'string' value as an attachment");
        }
        if (fields.size() > 1) {
            throw new InternalExpressionException("Expected only one of 'file', 'url', 'image', 'base64' or 'string' value as an attachment, but got " + String.join((CharSequence)" and ", fields));
        }
        if (this.file == null && this.file_shared.booleanValue()) {
            throw new InternalExpressionException("'file_shared' is only used when providing a 'file'");
        }
    }

    @Override
    public AbstractFile construct(Context context) {
        this.validateFields();
        if (this.file != null) {
            Pair resource = FileArgument.recognizeResource((String)this.file, (boolean)false, (FileArgument.Type)FileArgument.Type.ANY);
            FileArgument fileArgument = new FileArgument((String)resource.getLeft(), FileArgument.Type.ANY, (String)resource.getRight(), false, this.file_shared.booleanValue(), FileArgument.Reason.READ, context.host);
            Icon.IconType iconType = this.image_type == null ? null : Icon.IconType.fromExtension((String)this.image_type);
            return AbstractFile.ofFileArgument(context, fileArgument, iconType);
        }
        if (this.url != null) {
            Icon.IconType iconType = Icon.IconType.fromExtension((String)(this.image_type != null ? this.image_type : Objects.requireNonNullElse(FileUtil.getExtension(this.url), "png")));
            return AbstractFile.ofUrl(this.url, iconType);
        }
        if (this.string != null) {
            byte[] byteArr = this.string.getBytes(StandardCharsets.UTF_8);
            return AbstractFile.ofBytes(byteArr, Icon.IconType.fromExtension((String)Objects.requireNonNullElse(this.image_type, "png")));
        }
        if (this.base64 != null) {
            byte[] byteArr = Base64.getDecoder().decode(this.base64);
            return AbstractFile.ofBytes(byteArr, Icon.IconType.fromExtension((String)Objects.requireNonNullElse(this.image_type, "png")));
        }
        if (this.image != null) {
            if (!Discarpet.isScarpetGraphicsInstalled()) {
                throw new InternalExpressionException("scarpet-graphics is not installed, but required for an image file upload");
            }
            if (!ScarpetGraphicsDependency.isPixelAccessible(this.image)) {
                throw new InternalExpressionException("Image needs to be an image or graphics value");
            }
            BufferedImage bufferedImage = ScarpetGraphicsDependency.getImageFromValue(this.image);
            if (bufferedImage == null) {
                throw new InternalExpressionException("Value is not an image value");
            }
            Icon.IconType iconType = this.image_type == null ? Icon.IconType.PNG : Icon.IconType.fromExtension((String)this.image_type);
            return AbstractFile.ofBufferedImage(bufferedImage, iconType);
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean tryParseDirectly(Value value, Context context) {
        if (value instanceof StringValue) {
            String stringValue = value.getString();
            try {
                new URI(stringValue).toURL();
                this.url = stringValue;
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.file = stringValue;
            }
            return true;
        }
        if (Discarpet.isScarpetGraphicsInstalled() && ScarpetGraphicsDependency.isPixelAccessible(value)) {
            this.image = value;
            return true;
        }
        return false;
    }

    public static interface AbstractFile {
        public FileUpload asFileUpload();

        public AttachableUrl asUrl();

        public Icon asIcon();

        default public boolean requiresUpload() {
            return this.asUrl().optAttachment().isPresent();
        }

        public static AbstractFile ofFileArgument(final Context context, final FileArgument fileArgument, @Nullable Icon.IconType iconType) {
            if (iconType == null) {
                String extension = FileUtil.getExtension(fileArgument.resource);
                iconType = extension == null ? Icon.IconType.PNG : Icon.IconType.fromExtension((String)extension);
            }
            final Icon.IconType finalIconType = iconType;
            return new AbstractFile(){

                @Override
                public FileUpload asFileUpload() {
                    return FileUtil.fromFileArgument(context, fileArgument);
                }

                @Override
                public AttachableUrl asUrl() {
                    return AttachableUrl.attached(this.asFileUpload());
                }

                @Override
                public Icon asIcon() {
                    try {
                        return Icon.from((InputStream)FileUtil.inputStreamFromFileArgument(context, fileArgument), (Icon.IconType)finalIconType);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        public static AbstractFile ofUrl(final String url, @Nullable Icon.IconType iconType) {
            if (iconType == null) {
                String extension = FileUtil.getExtension(url);
                iconType = extension == null ? Icon.IconType.PNG : Icon.IconType.fromExtension((String)extension);
            }
            final Icon.IconType finalIconType = iconType;
            return new AbstractFile(){

                @Override
                public FileUpload asFileUpload() {
                    return FileUtil.fromUrl(url);
                }

                @Override
                public AttachableUrl asUrl() {
                    return AttachableUrl.ofUrl(url);
                }

                @Override
                public Icon asIcon() {
                    try {
                        return Icon.from((InputStream)FileUtil.inputStreamFromUrl(url), (Icon.IconType)finalIconType);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }

        public static AbstractFile ofBytes(final byte[] byteArr, final @Nullable Icon.IconType iconType) {
            return new AbstractFile(){

                @Override
                public FileUpload asFileUpload() {
                    return FileUpload.fromData((byte[])byteArr, (String)FileUtil.randomName(iconType == null ? null : iconType.name().toLowerCase()));
                }

                @Override
                public AttachableUrl asUrl() {
                    return AttachableUrl.attached(this.asFileUpload());
                }

                @Override
                public Icon asIcon() {
                    return Icon.from((byte[])byteArr, (Icon.IconType)(iconType == null ? Icon.IconType.PNG : iconType));
                }
            };
        }

        public static AbstractFile ofBufferedImage(BufferedImage bufferedImage, final Icon.IconType iconType) {
            final String fileExtension = iconType.name().toLowerCase();
            final Supplier<InputStream> inputStreamSupplier = FileUtil.imageToInputStreamSupplier(bufferedImage, fileExtension);
            return new AbstractFile(){

                @Override
                public FileUpload asFileUpload() {
                    return FileUpload.fromStreamSupplier((String)FileUtil.randomName(fileExtension), (Supplier)inputStreamSupplier);
                }

                @Override
                public AttachableUrl asUrl() {
                    return AttachableUrl.attached(this.asFileUpload());
                }

                @Override
                public Icon asIcon() {
                    try {
                        return Icon.from((InputStream)((InputStream)inputStreamSupplier.get()), (Icon.IconType)iconType);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
        }
    }

    public record AttachableUrl(String url, @Nullable FileUpload attachment) {
        public static AttachableUrl attached(FileUpload upload) {
            return new AttachableUrl("attachment://" + upload.getName(), upload);
        }

        public static AttachableUrl ofUrl(String url) {
            return new AttachableUrl(url, null);
        }

        public Optional<FileUpload> optAttachment() {
            return Optional.ofNullable(this.attachment);
        }
    }
}

