/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas;

import carpet.script.Context;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.MapValue;
import carpet.script.value.Value;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.label.LabelChildComponent;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReference;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.AbstractMessageBuilder;
import net.dv8tion.jda.api.utils.messages.MessageCreateBuilder;
import net.dv8tion.jda.api.utils.messages.MessageData;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import net.replaceitem.discarpet.script.schema.DirectParsable;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.schemas.AllowedMentionsSchema;
import net.replaceitem.discarpet.script.schema.schemas.AttachmentSchema;
import net.replaceitem.discarpet.script.schema.schemas.embeds.EmbedSchema;
import net.replaceitem.discarpet.script.util.ComponentUtil;
import net.replaceitem.discarpet.script.values.StickerValue;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="message_content")
public class MessageContentSchema
implements DirectParsable {
    @OptionalField
    @Nullable
    String content;
    @OptionalField
    List<FileUpload> attachments = List.of();
    @OptionalField
    List<Value> stickers = List.of();
    @OptionalField
    List<EmbedSchema.EmbedWithAttachments> embeds = List.of();
    @OptionalField
    List<Component> components = List.of();
    @OptionalField
    Boolean use_components_v2 = false;
    @OptionalField
    @Nullable
    AllowedMentionsSchema allowed_mentions;
    @OptionalField
    @Nullable
    Message referenced_message;
    @OptionalField
    MessageReference.MessageReferenceType message_reference_type = MessageReference.MessageReferenceType.DEFAULT;
    @OptionalField
    @Nullable
    String nonce;
    @OptionalField
    Boolean tts = false;
    @OptionalField
    Boolean ephemeral = false;
    @OptionalField
    Boolean suppress_embeds = false;
    @OptionalField
    Boolean suppress_notifications = false;

    public <B extends AbstractMessageBuilder<D, B>, D extends MessageData, A extends RestAction<?>> A apply(B builder, Function<B, D> build, Function<D, A> send) {
        MessageCreateAction messageCreateAction;
        MessageData data;
        RestAction action;
        if (!this.use_components_v2.booleanValue()) {
            builder.setContent("-");
        }
        builder.setFiles(Stream.of(this.attachments.stream(), this.embeds.stream().flatMap(embedObject -> embedObject.getFileUploads().stream())).flatMap(Function.identity()).toList());
        builder.setEmbeds(this.embeds.stream().map(AttachmentSchema.WithAttachments::getData).toList());
        List<MessageTopLevelComponent> messageComponents = ComponentUtil.ensureComponentType(this.components, MessageTopLevelComponent.class, component -> {
            String additionalInfo = component instanceof LabelChildComponent ? " Consider wrapping it inside a label." : "";
            return "Components of type %s cannot be used inside a message.%s".formatted(component.getType().toString().toLowerCase(), additionalInfo);
        });
        builder.setComponents(messageComponents);
        builder.useComponentsV2(this.use_components_v2.booleanValue());
        if (this.allowed_mentions != null) {
            this.allowed_mentions.apply((MessageRequest<?>)builder);
        }
        builder.setSuppressEmbeds(this.suppress_embeds.booleanValue());
        if (this.tts.booleanValue()) {
            if (builder instanceof MessageCreateBuilder) {
                MessageCreateBuilder messageCreateBuilder = (MessageCreateBuilder)builder;
                messageCreateBuilder.setTTS(true);
            } else {
                throw MessageContentSchema.onlyCreate("tts");
            }
        }
        if ((action = (RestAction)send.apply(data = (MessageData)build.apply(builder))) instanceof MessageRequest) {
            MessageRequest messageRequest = (MessageRequest)action;
            messageRequest.setContent(this.content);
        }
        if (this.referenced_message != null) {
            if (action instanceof MessageCreateAction) {
                messageCreateAction = (MessageCreateAction)action;
                messageCreateAction.setMessageReference(this.message_reference_type, this.referenced_message);
            } else {
                throw MessageContentSchema.onlyCreate("referenced_message");
            }
        }
        if (this.nonce != null) {
            if (action instanceof MessageCreateAction) {
                messageCreateAction = (MessageCreateAction)action;
                messageCreateAction.setNonce(this.nonce);
            } else {
                throw MessageContentSchema.onlyCreate("nonce");
            }
        }
        if (this.suppress_notifications.booleanValue()) {
            if (action instanceof MessageCreateAction) {
                messageCreateAction = (MessageCreateAction)action;
                messageCreateAction.setSuppressedNotifications(true);
            } else {
                throw MessageContentSchema.onlyCreate("suppress_notifications");
            }
        }
        if (!this.stickers.isEmpty()) {
            if (action instanceof MessageCreateAction) {
                messageCreateAction = (MessageCreateAction)action;
                messageCreateAction.setStickers(this.stickers.stream().map(value -> {
                    String string;
                    if (value instanceof StickerValue) {
                        StickerValue stickerValue = (StickerValue)value;
                        string = ((Sticker)stickerValue.getDelegate()).getId();
                    } else {
                        string = value.getString();
                    }
                    return Sticker.fromId((String)string);
                }).toList());
            } else {
                throw MessageContentSchema.onlyCreate("stickers");
            }
        }
        if (this.ephemeral.booleanValue()) {
            if (action instanceof WebhookMessageCreateAction) {
                WebhookMessageCreateAction webhookMessageCreateAction = (WebhookMessageCreateAction)action;
                webhookMessageCreateAction.setEphemeral(true);
            } else if (action instanceof ReplyCallbackAction) {
                ReplyCallbackAction replyCallbackAction = (ReplyCallbackAction)action;
                replyCallbackAction.setEphemeral(true);
            } else {
                throw new InternalExpressionException("'ephemeral' is only supported for interaction replies");
            }
        }
        return (A)action;
    }

    @Override
    public boolean tryParseDirectly(Value value, Context context) {
        if (!(value instanceof MapValue)) {
            this.content = value.getString();
            return true;
        }
        return false;
    }

    private static InternalExpressionException onlyCreate(String field) {
        return new InternalExpressionException("'" + field + "' is only supported for message creation, not edits");
    }
}

