/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas;

import carpet.script.Context;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.time.Instant;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.SchemaConstructor;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="timestamp")
public class TimestampSchema
implements SchemaConstructor<Instant> {
    Long epoch_millis;

    @Override
    public Instant construct(Context context) {
        return Instant.ofEpochMilli(this.epoch_millis);
    }

    @Override
    @Nullable
    public Instant tryCreateFromValueDirectly(Value value) {
        if (value instanceof NumericValue) {
            NumericValue numericTimestamp = (NumericValue)value;
            return Instant.ofEpochMilli(numericTimestamp.getLong());
        }
        if (value.getString().equalsIgnoreCase("now")) {
            return Instant.now();
        }
        return null;
    }
}

