/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas.components;

import carpet.script.Context;
import java.util.EnumSet;
import java.util.List;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.selections.EntitySelectMenu;
import net.dv8tion.jda.api.components.selections.SelectMenu;
import net.dv8tion.jda.api.components.selections.SelectOption;
import net.dv8tion.jda.api.components.selections.StringSelectMenu;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.SchemaConstructor;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="select_menu")
public class SelectMenuSchema
implements SchemaConstructor<SelectMenu> {
    String id;
    Component.Type component;
    @OptionalField
    Boolean disabled = false;
    @OptionalField
    List<SelectOption> options = List.of();
    @OptionalField
    @Nullable
    List<ChannelType> channel_types;
    @OptionalField
    Integer min = 1;
    @OptionalField
    Integer max = 1;
    @OptionalField
    @Nullable
    String placeholder;

    @Override
    public SelectMenu construct(Context context) {
        StringSelectMenu.Builder builder = switch (this.component) {
            case Component.Type.STRING_SELECT -> StringSelectMenu.create((String)this.id).addOptions(this.options);
            case Component.Type.USER_SELECT -> EntitySelectMenu.create((String)this.id, (EntitySelectMenu.SelectTarget)EntitySelectMenu.SelectTarget.USER, (EntitySelectMenu.SelectTarget[])new EntitySelectMenu.SelectTarget[0]);
            case Component.Type.CHANNEL_SELECT -> {
                EntitySelectMenu.Builder channelBuilder = EntitySelectMenu.create((String)this.id, (EntitySelectMenu.SelectTarget)EntitySelectMenu.SelectTarget.CHANNEL, (EntitySelectMenu.SelectTarget[])new EntitySelectMenu.SelectTarget[0]);
                if (this.channel_types != null) {
                    channelBuilder.setChannelTypes(this.channel_types);
                }
                yield channelBuilder;
            }
            case Component.Type.ROLE_SELECT -> EntitySelectMenu.create((String)this.id, (EntitySelectMenu.SelectTarget)EntitySelectMenu.SelectTarget.ROLE, (EntitySelectMenu.SelectTarget[])new EntitySelectMenu.SelectTarget[0]);
            case Component.Type.MENTIONABLE_SELECT -> EntitySelectMenu.create((String)this.id, EnumSet.of(EntitySelectMenu.SelectTarget.USER, EntitySelectMenu.SelectTarget.ROLE));
            default -> throw new IllegalArgumentException("ComponentSchema redirected to SelectMenuSchema, but type is invalid for select menu. Report this to discarpet.");
        };
        builder.setDisabled(this.disabled.booleanValue()).setRequiredRange(this.min.intValue(), this.max.intValue());
        builder.setPlaceholder(this.placeholder);
        return builder.build();
    }
}

