/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.schema.schemas.embeds;

import carpet.script.Context;
import java.awt.Color;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.utils.FileUpload;
import net.replaceitem.discarpet.script.schema.OptionalField;
import net.replaceitem.discarpet.script.schema.SchemaClass;
import net.replaceitem.discarpet.script.schema.SchemaConstructor;
import net.replaceitem.discarpet.script.schema.schemas.AttachmentSchema;
import net.replaceitem.discarpet.script.schema.schemas.FileSchema;
import net.replaceitem.discarpet.script.schema.schemas.embeds.EmbedAuthorSchema;
import net.replaceitem.discarpet.script.schema.schemas.embeds.EmbedFieldSchema;
import net.replaceitem.discarpet.script.schema.schemas.embeds.EmbedFooterSchema;
import org.jetbrains.annotations.Nullable;

@SchemaClass(name="embed")
public class EmbedSchema
implements SchemaConstructor<EmbedWithAttachments> {
    @OptionalField
    @Nullable
    String title;
    @OptionalField
    @Nullable
    String url;
    @OptionalField
    @Nullable
    String description;
    @OptionalField
    @Nullable
    EmbedAuthorSchema author;
    @OptionalField
    List<EmbedFieldSchema> fields = List.of();
    @OptionalField
    @Nullable
    Color color;
    @OptionalField
    @Nullable
    EmbedFooterSchema footer;
    @OptionalField
    @Nullable
    FileSchema.AbstractFile image;
    @OptionalField
    @Nullable
    FileSchema.AbstractFile thumbnail;
    @OptionalField
    @Nullable
    Instant timestamp;

    @Override
    public EmbedWithAttachments construct(Context context) {
        FileSchema.AttachableUrl attachableUrl;
        ArrayList<FileUpload> fileUploads = new ArrayList<FileUpload>(0);
        EmbedBuilder embedBuilder = new EmbedBuilder();
        embedBuilder.setTitle(this.title);
        embedBuilder.setUrl(this.url);
        embedBuilder.setDescription((CharSequence)this.description);
        embedBuilder.setColor(this.color);
        embedBuilder.setTimestamp((TemporalAccessor)this.timestamp);
        for (EmbedFieldSchema field : this.fields) {
            field.apply(embedBuilder);
        }
        if (this.author != null) {
            if (this.author.getFileUpload() != null) {
                fileUploads.add(this.author.getFileUpload());
            }
            this.author.apply(embedBuilder);
        }
        if (this.footer != null) {
            if (this.footer.getFileUpload() != null) {
                fileUploads.add(this.footer.getFileUpload());
            }
            this.footer.apply(embedBuilder);
        }
        if (this.image != null) {
            attachableUrl = this.image.asUrl();
            attachableUrl.optAttachment().ifPresent(fileUploads::add);
            embedBuilder.setImage(attachableUrl.url());
        }
        if (this.thumbnail != null) {
            attachableUrl = this.thumbnail.asUrl();
            attachableUrl.optAttachment().ifPresent(fileUploads::add);
            embedBuilder.setThumbnail(attachableUrl.url());
        }
        return new EmbedWithAttachments(embedBuilder.build(), (List<FileUpload>)fileUploads);
    }

    public static class EmbedWithAttachments
    extends AttachmentSchema.WithAttachments<MessageEmbed> {
        public EmbedWithAttachments(MessageEmbed data, List<FileUpload> fileUploads) {
            super(data, fileUploads);
        }
    }
}

