/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.util;

import carpet.script.exception.InternalExpressionException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnumUtil {
    public static <T extends Enum<T>> Optional<T> getEnum(Class<T> enumClass, String name) {
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(name)) continue;
            return Optional.of(enumConstant);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> T getEnumOrThrow(Class<T> enumClass, String name, String error) {
        return (T)((Enum)EnumUtil.getEnum(enumClass, name).orElseThrow(() -> new InternalExpressionException("%s: Value %s is unknown, expected one of %s%s".formatted(error, name, Arrays.stream((Enum[])enumClass.getEnumConstants()).limit(8L).map(type -> type.name().toLowerCase()).filter(n -> !n.equalsIgnoreCase("unknown")).collect(Collectors.joining(", ")), ((Enum[])enumClass.getEnumConstants()).length > 8 ? ", ..." : ""))));
    }
}

