/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.util;

import carpet.script.annotation.OutputConverter;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.Value;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class ValueConversions {
    @Nullable
    private static <V> OutputConverter<V> getOutputConverter(Class<V> inputClass) {
        try {
            return OutputConverter.get(inputClass);
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    @Nullable
    private static Class<?> findOutputConvertibleInterface(Class<?> inputClass) {
        if (ValueConversions.getOutputConverter(inputClass) != null) {
            return inputClass;
        }
        return Stream.concat(Stream.of(inputClass.getSuperclass()), Arrays.stream(inputClass.getInterfaces())).filter(Objects::nonNull).map(ValueConversions::findOutputConvertibleInterface).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static Value toValue(@Nullable Object object) {
        if (object == null) {
            return Value.NULL;
        }
        Class<?> toClass = ValueConversions.findOutputConvertibleInterface(object.getClass());
        if (toClass == null) {
            throw new InternalExpressionException("Could not find an interface for an output converter for DiscordValue.of() and type " + String.valueOf(object.getClass()));
        }
        OutputConverter<?> converter = ValueConversions.getOutputConverter(toClass);
        if (converter == null) {
            throw new InternalExpressionException("Could not find a suitable output converter for DiscordValue.of() and type " + String.valueOf(object.getClass()));
        }
        return converter.convert(object, null);
    }
}

