/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.util;

import carpet.script.value.BooleanValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.awt.Color;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import org.jetbrains.annotations.Nullable;

public class ValueUtil {
    public static <T> T awaitFuture(CompletableFuture<T> cf, String message) {
        try {
            return cf.get();
        }
        catch (Exception e) {
            throw DiscordThrowables.convert(e, message);
        }
    }

    public static <T> T awaitRest(RestAction<T> restAction, String message) {
        try {
            return (T)restAction.complete();
        }
        catch (Exception e) {
            throw DiscordThrowables.convert(e, message);
        }
    }

    public static <T> Value ofNullable(@Nullable T val, Function<T, Value> constructor) {
        return val == null ? Value.NULL : constructor.apply(val);
    }

    @Nullable
    public static <T> T unpackOptional(Optional<T> optional) {
        return optional.orElse(null);
    }

    public static Value ofOptionalString(Optional<String> optionalString) {
        return optionalString.map(StringValue::of).orElse((Value)Value.NULL);
    }

    public static Value ofOptionalNumber(Optional<? extends Number> optionalInteger) {
        return optionalInteger.map(NumericValue::of).orElse((Value)Value.NULL);
    }

    public static Value ofOptionalBoolean(Optional<Boolean> optionalBoolean) {
        if (optionalBoolean.isEmpty()) {
            return Value.NULL;
        }
        return BooleanValue.of((boolean)optionalBoolean.get());
    }

    public static Value ofPositiveInt(int v) {
        if (v < 0) {
            return Value.NULL;
        }
        return NumericValue.of((Number)v);
    }

    public static Value ofEnum(Enum<?> enumValue) {
        return StringValue.of((String)enumValue.name().toLowerCase(Locale.ROOT));
    }

    public static Value ofInstant(@Nullable Instant instant) {
        return instant == null ? Value.NULL : NumericValue.of((Number)instant.toEpochMilli());
    }

    public static Value ofTime(@Nullable OffsetDateTime time) {
        return time == null ? Value.NULL : ValueUtil.ofInstant(time.toInstant());
    }

    public static Value colorToValue(@Nullable Color color) {
        if (color == null) {
            return Value.NULL;
        }
        return StringValue.of((String)String.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue()));
    }

    @Nullable
    public static <T> T optionalArg(T @Nullable [] array, int index) {
        if (array == null) {
            return null;
        }
        return array.length > index ? (T)array[index] : null;
    }

    @Nullable
    public static <T> T optionalArg(T @Nullable [] array) {
        return ValueUtil.optionalArg(array, 0);
    }
}

