/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.BooleanValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.io.IOException;
import java.io.InputStream;
import net.dv8tion.jda.api.entities.Message;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import org.jetbrains.annotations.Nullable;

public class AttachmentValue
extends DiscordValue<Message.Attachment> {
    public AttachmentValue(Message.Attachment attachment) {
        super(attachment);
    }

    public static Value of(@Nullable Message.Attachment messageAttachment) {
        return ValueUtil.ofNullable(messageAttachment, AttachmentValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "attachment_value";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "file_name" -> StringValue.of((String)((Message.Attachment)this.delegate).getFileName());
            case "size" -> NumericValue.of((Number)((Message.Attachment)this.delegate).getSize());
            case "url" -> StringValue.of((String)((Message.Attachment)this.delegate).getUrl());
            case "proxy_url" -> StringValue.of((String)((Message.Attachment)this.delegate).getProxyUrl());
            case "is_image" -> BooleanValue.of((boolean)((Message.Attachment)this.delegate).isImage());
            case "width" -> ValueUtil.ofPositiveInt(((Message.Attachment)this.delegate).getWidth());
            case "height" -> ValueUtil.ofPositiveInt(((Message.Attachment)this.delegate).getHeight());
            case "is_spoiler" -> BooleanValue.of((boolean)((Message.Attachment)this.delegate).isSpoiler());
            case "download" -> StringValue.of((String)this.download());
            default -> super.getProperty(property);
        };
    }

    private String download() {
        String string;
        block8: {
            InputStream is = (InputStream)ValueUtil.awaitFuture(((Message.Attachment)this.delegate).getProxy().download(), "Error downloading attachment");
            try {
                string = new String(is.readAllBytes());
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw DiscordThrowables.convert(e, "Could not download attachment data");
                }
            }
            is.close();
        }
        return string;
    }
}

