/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.BooleanValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.List;
import java.util.Optional;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.entities.channel.attribute.IAgeRestrictedChannel;
import net.dv8tion.jda.api.entities.channel.attribute.IPositionableChannel;
import net.dv8tion.jda.api.entities.channel.attribute.IWebhookContainer;
import net.dv8tion.jda.api.entities.channel.middleman.GuildChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.internal.entities.channel.mixin.attribute.ITopicChannelMixin;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.ServerValue;
import net.replaceitem.discarpet.script.values.WebhookValue;
import net.replaceitem.discarpet.script.values.common.MessageableValue;
import net.replaceitem.discarpet.script.values.common.Renamable;
import org.jetbrains.annotations.Nullable;

public class ChannelValue
extends MessageableValue<Channel>
implements Renamable {
    public ChannelValue(Channel channel) {
        super(channel);
    }

    public static Value of(@Nullable Channel channel) {
        return ValueUtil.ofNullable(channel, ChannelValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "channel";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "name" -> StringValue.of(((Channel)this.delegate).getName().isEmpty() ? null : ((Channel)this.delegate).getName());
            case "type" -> ValueUtil.ofEnum(((Channel)this.delegate).getType());
            case "topic" -> {
                String v1;
                Object var5_4 = this.delegate;
                if (var5_4 instanceof ITopicChannelMixin) {
                    ITopicChannelMixin topicChannelMixin = (ITopicChannelMixin)var5_4;
                    v1 = topicChannelMixin.getTopic();
                } else {
                    v1 = null;
                }
                yield StringValue.of(v1);
            }
            case "id" -> StringValue.of((String)((Channel)this.delegate).getId());
            case "mention_tag" -> StringValue.of((String)((Channel)this.delegate).getAsMention());
            case "server" -> {
                Guild v2;
                Object var5_5 = this.delegate;
                if (var5_5 instanceof GuildChannel) {
                    GuildChannel guildChannel = (GuildChannel)var5_5;
                    v2 = guildChannel.getGuild();
                } else {
                    v2 = null;
                }
                yield ServerValue.of(v2);
            }
            case "webhooks" -> {
                Object var5_6 = this.delegate;
                if (var5_6 instanceof IWebhookContainer) {
                    IWebhookContainer webhookContainer = (IWebhookContainer)var5_6;
                    yield ListValue.wrap(((List)ValueUtil.awaitRest(webhookContainer.retrieveWebhooks(), "Error getting webhooks from channel")).stream().map(WebhookValue::of));
                }
                yield Value.NULL;
            }
            case "nsfw" -> {
                IAgeRestrictedChannel ageRestrictedChannel;
                Object var5_7 = this.delegate;
                yield BooleanValue.of((var5_7 instanceof IAgeRestrictedChannel && (ageRestrictedChannel = (IAgeRestrictedChannel)var5_7).isNSFW() ? 1 : 0) != 0);
            }
            case "position" -> {
                Object var5_8 = this.delegate;
                if (var5_8 instanceof IPositionableChannel) {
                    IPositionableChannel positionableChannel = (IPositionableChannel)var5_8;
                    yield NumericValue.of((Number)positionableChannel.getPositionRaw());
                }
                yield Value.NULL;
            }
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> rename(String name) {
        Object object = this.delegate;
        if (!(object instanceof GuildChannel)) {
            throw DiscordThrowables.genericCode(ErrorResponse.INVALID_CHANNEL_TYPE);
        }
        GuildChannel guildChannel = (GuildChannel)object;
        return guildChannel.getManager().setName(name);
    }

    @Override
    public Optional<MessageableValue.MessageConsumer> getMessageConsumer() {
        Optional<MessageableValue.MessageConsumer> optional;
        Object object = this.delegate;
        if (object instanceof MessageChannel) {
            MessageChannel messageable = (MessageChannel)object;
            optional = Optional.of(arg_0 -> ((MessageChannel)messageable).sendMessage(arg_0));
        } else {
            optional = Optional.empty();
        }
        return optional;
    }
}

