/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.ListValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.mixins.CommandImplMixin;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.ServerValue;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import org.jetbrains.annotations.Nullable;

public class CommandValue
extends DiscordValue<Command>
implements Deletable {
    public CommandValue(Command applicationCommand) {
        super(applicationCommand);
    }

    public static Value of(@Nullable Command command) {
        return ValueUtil.ofNullable(command, CommandValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "command";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "id" -> StringValue.of((String)((Command)this.delegate).getId());
            case "name" -> StringValue.of((String)((Command)this.delegate).getName());
            case "description" -> StringValue.of((String)((Command)this.delegate).getDescription());
            case "type" -> ValueUtil.ofEnum(((Command)this.delegate).getType());
            case "server" -> ServerValue.of(((CommandImplMixin)this.delegate).getGuild());
            case "options" -> ListValue.wrap(((Command)this.delegate).getOptions().stream().map(slashCommandOption -> StringValue.of((String)slashCommandOption.getName())));
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> delete(@Nullable String reason) {
        return ((Command)this.delegate).delete();
    }
}

