/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.BooleanValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.RichCustomEmoji;
import net.dv8tion.jda.api.entities.emoji.UnicodeEmoji;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import net.replaceitem.discarpet.script.values.common.Renamable;
import org.jetbrains.annotations.Nullable;

public class EmojiValue
extends DiscordValue<Emoji>
implements Deletable,
Renamable {
    public EmojiValue(Emoji emoji) {
        super(emoji);
    }

    public static Value of(@Nullable Emoji emoji) {
        return ValueUtil.ofNullable(emoji, EmojiValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "emoji";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "id" -> {
                String v0;
                Object var5_4 = this.delegate;
                if (var5_4 instanceof CustomEmoji) {
                    CustomEmoji customEmoji = (CustomEmoji)var5_4;
                    v0 = customEmoji.getId();
                } else {
                    v0 = null;
                }
                yield StringValue.of(v0);
            }
            case "mention_tag" -> {
                String v2;
                Object var5_5 = this.delegate;
                if (var5_5 instanceof CustomEmoji) {
                    CustomEmoji customEmoji = (CustomEmoji)var5_5;
                    v2 = customEmoji.getAsMention();
                } else {
                    v2 = ((Emoji)this.delegate).getName();
                }
                yield StringValue.of((String)v2);
            }
            case "unicode" -> {
                String v3;
                Object var5_6 = this.delegate;
                if (var5_6 instanceof UnicodeEmoji) {
                    UnicodeEmoji unicodeEmoji = (UnicodeEmoji)var5_6;
                    v3 = unicodeEmoji.getName();
                } else {
                    v3 = null;
                }
                yield StringValue.of(v3);
            }
            case "is_animated" -> {
                CustomEmoji customEmoji;
                Object var5_7 = this.delegate;
                yield BooleanValue.of((var5_7 instanceof CustomEmoji && (customEmoji = (CustomEmoji)var5_7).isAnimated() ? 1 : 0) != 0);
            }
            case "is_unicode" -> BooleanValue.of((boolean)(this.delegate instanceof UnicodeEmoji));
            case "is_custom" -> BooleanValue.of((boolean)(this.delegate instanceof CustomEmoji));
            case "type" -> ValueUtil.ofEnum(((Emoji)this.delegate).getType());
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> delete(@Nullable String reason) {
        Object object = this.delegate;
        if (!(object instanceof RichCustomEmoji)) {
            throw DiscordThrowables.genericCode(ErrorResponse.UNKNOWN_EMOJI);
        }
        RichCustomEmoji customEmoji = (RichCustomEmoji)object;
        return customEmoji.delete().reason(reason);
    }

    @Override
    public RestAction<?> rename(String name) {
        Object object = this.delegate;
        if (!(object instanceof RichCustomEmoji)) {
            throw DiscordThrowables.genericCode(ErrorResponse.UNKNOWN_EMOJI);
        }
        RichCustomEmoji customEmoji = (RichCustomEmoji)object;
        return customEmoji.getManager().setName(name);
    }
}

