/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.BooleanValue;
import carpet.script.value.ListValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.Member;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.RoleValue;
import net.replaceitem.discarpet.script.values.ServerValue;
import net.replaceitem.discarpet.script.values.UserValue;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import org.jetbrains.annotations.Nullable;

public class MemberValue
extends DiscordValue<Member> {
    public MemberValue(Member delegate) {
        super(delegate);
    }

    public static Value of(@Nullable Member member) {
        return ValueUtil.ofNullable(member, MemberValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "member";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "user" -> UserValue.of(((Member)this.delegate).getUser());
            case "server" -> ServerValue.of(((Member)this.delegate).getGuild());
            case "color" -> ValueUtil.colorToValue(((Member)this.delegate).getColor());
            case "roles" -> ListValue.wrap(((Member)this.delegate).getRoles().stream().map(RoleValue::of));
            case "nickname" -> StringValue.of((String)((Member)this.delegate).getNickname());
            case "effective_name" -> StringValue.of((String)((Member)this.delegate).getEffectiveName());
            case "online_status" -> ValueUtil.ofEnum(((Member)this.delegate).getOnlineStatus());
            case "is_boosting" -> BooleanValue.of((boolean)((Member)this.delegate).isBoosting());
            case "is_owner" -> BooleanValue.of((boolean)((Member)this.delegate).isOwner());
            case "is_pending" -> BooleanValue.of((boolean)((Member)this.delegate).isPending());
            case "is_self" -> BooleanValue.of((((Member)this.delegate).getIdLong() == ((Member)this.delegate).getJDA().getSelfUser().getIdLong() ? 1 : 0) != 0);
            case "timeout_end" -> ValueUtil.ofTime(((Member)this.delegate).getTimeOutEnd());
            case "avatar_url" -> StringValue.of((String)((Member)this.delegate).getAvatarUrl());
            case "effective_avatar_url" -> StringValue.of((String)((Member)this.delegate).getEffectiveAvatarUrl());
            default -> super.getProperty(property);
        };
    }
}

