/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.ListValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.ISnowflake;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.AttachmentValue;
import net.replaceitem.discarpet.script.values.ChannelValue;
import net.replaceitem.discarpet.script.values.MemberValue;
import net.replaceitem.discarpet.script.values.ServerValue;
import net.replaceitem.discarpet.script.values.StickerValue;
import net.replaceitem.discarpet.script.values.UserValue;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import org.jetbrains.annotations.Nullable;

public class MessageValue
extends DiscordValue<Message>
implements Deletable {
    public MessageValue(Message message) {
        super(message);
    }

    public static Value of(@Nullable Message message) {
        return ValueUtil.ofNullable(message, MessageValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "message";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "content" -> StringValue.of((String)((Message)this.delegate).getContentRaw());
            case "readable_content" -> StringValue.of((String)((Message)this.delegate).getContentDisplay());
            case "stripped_content" -> StringValue.of((String)((Message)this.delegate).getContentStripped());
            case "id" -> StringValue.of((String)((Message)this.delegate).getId());
            case "channel" -> ChannelValue.of((Channel)((Message)this.delegate).getChannel());
            case "user" -> UserValue.of(((Message)this.delegate).getAuthor());
            case "member" -> MemberValue.of(((Message)this.delegate).getMember());
            case "webhook_id" -> StringValue.of(((Message)this.delegate).isWebhookMessage() ? ((Message)this.delegate).getAuthor().getId() : null);
            case "server" -> ServerValue.of(((Message)this.delegate).getGuild());
            case "nonce" -> StringValue.of((String)((Message)this.delegate).getNonce());
            case "attachments" -> ListValue.wrap(((Message)this.delegate).getAttachments().stream().map(AttachmentValue::new));
            case "sticker_ids" -> ListValue.wrap(((Message)this.delegate).getStickers().stream().map(ISnowflake::getId).map(StringValue::of));
            case "stickers" -> ListValue.wrap(((Message)this.delegate).getStickers().stream().map(StickerValue::new));
            case "referenced_message" -> MessageValue.of(((Message)this.delegate).getReferencedMessage());
            case "type" -> ValueUtil.ofEnum(((Message)this.delegate).getType());
            case "link" -> StringValue.of((String)((Message)this.delegate).getJumpUrl());
            case "flags" -> ListValue.wrap(((Message)this.delegate).getFlags().stream().map(ValueUtil::ofEnum));
            case "creation_timestamp" -> ValueUtil.ofTime(((Message)this.delegate).getTimeCreated());
            case "edit_timestamp" -> ValueUtil.ofTime(((Message)this.delegate).getTimeEdited());
            case "position" -> ValueUtil.ofPositiveInt(((Message)this.delegate).getApproximatePosition());
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> delete(@Nullable String reason) {
        return ((Message)this.delegate).delete().reason(reason);
    }
}

