/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.BooleanValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.MemberValue;
import net.replaceitem.discarpet.script.values.ServerValue;
import net.replaceitem.discarpet.script.values.UserValue;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import net.replaceitem.discarpet.script.values.common.Renamable;
import org.jetbrains.annotations.Nullable;

public class RoleValue
extends DiscordValue<Role>
implements Deletable,
Renamable {
    public RoleValue(Role role) {
        super(role);
    }

    public static Value of(@Nullable Role role) {
        return ValueUtil.ofNullable(role, RoleValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "role";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "name" -> StringValue.of((String)((Role)this.delegate).getName());
            case "id" -> StringValue.of((String)((Role)this.delegate).getId());
            case "mention_tag" -> StringValue.of((String)((Role)this.delegate).getAsMention());
            case "color" -> ValueUtil.colorToValue(((Role)this.delegate).getColor());
            case "position" -> NumericValue.of((Number)((Role)this.delegate).getPosition());
            case "server" -> ServerValue.of(((Role)this.delegate).getGuild());
            case "members" -> ListValue.wrap(((Role)this.delegate).getGuild().getMembersWithRoles(new Role[]{(Role)this.delegate}).stream().map(MemberValue::new));
            case "users" -> ListValue.wrap(((Role)this.delegate).getGuild().getMembersWithRoles(new Role[]{(Role)this.delegate}).stream().map(Member::getUser).map(UserValue::new));
            case "displayed_separately" -> BooleanValue.of((boolean)((Role)this.delegate).isHoisted());
            case "is_everyone_value" -> BooleanValue.of((((Role)this.delegate).getIdLong() == ((Role)this.delegate).getGuild().getIdLong() ? 1 : 0) != 0);
            case "managed" -> BooleanValue.of((boolean)((Role)this.delegate).isManaged());
            case "mentionable" -> BooleanValue.of((boolean)((Role)this.delegate).isMentionable());
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> delete(@Nullable String reason) {
        return ((Role)this.delegate).delete().reason(reason);
    }

    @Override
    public RestAction<?> rename(String name) {
        return ((Role)this.delegate).getManager().setName(name);
    }
}

