/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.dv8tion.jda.api.entities.sticker.GuildSticker;
import net.dv8tion.jda.api.entities.sticker.RichSticker;
import net.dv8tion.jda.api.entities.sticker.StandardSticker;
import net.dv8tion.jda.api.entities.sticker.Sticker;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.ServerValue;
import net.replaceitem.discarpet.script.values.UserValue;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.DiscordValue;
import net.replaceitem.discarpet.script.values.common.Renamable;
import org.jetbrains.annotations.Nullable;

public class StickerValue
extends DiscordValue<Sticker>
implements Deletable,
Renamable {
    public StickerValue(Sticker sticker) {
        super(sticker);
    }

    public static Value of(@Nullable Sticker sticker) {
        return ValueUtil.ofNullable(sticker, StickerValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "sticker";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "id" -> StringValue.of((String)((Sticker)this.delegate).getId());
            case "name" -> StringValue.of((String)((Sticker)this.delegate).getName());
            case "description" -> {
                String v1;
                Object var5_4 = this.delegate;
                if (var5_4 instanceof RichSticker) {
                    RichSticker richSticker = (RichSticker)var5_4;
                    v1 = richSticker.getDescription();
                } else {
                    v1 = null;
                }
                yield StringValue.of(v1);
            }
            case "tags" -> {
                Object var5_5 = this.delegate;
                if (var5_5 instanceof RichSticker) {
                    RichSticker richSticker = (RichSticker)var5_5;
                    yield ListValue.wrap(richSticker.getTags().stream().map(StringValue::of));
                }
                yield Value.NULL;
            }
            case "sort_value" -> {
                Object var5_6 = this.delegate;
                if (var5_6 instanceof StandardSticker) {
                    StandardSticker standardSticker = (StandardSticker)var5_6;
                    yield NumericValue.of((Number)standardSticker.getSortValue());
                }
                yield Value.NULL;
            }
            case "format_type" -> ValueUtil.ofEnum(((Sticker)this.delegate).getFormatType());
            case "pack_id" -> {
                Object var5_7 = this.delegate;
                if (var5_7 instanceof StandardSticker) {
                    StandardSticker standardSticker = (StandardSticker)var5_7;
                    yield StringValue.of((String)standardSticker.getPackId());
                }
                yield Value.NULL;
            }
            case "server" -> {
                Object var5_8 = this.delegate;
                if (var5_8 instanceof GuildSticker) {
                    GuildSticker guildSticker = (GuildSticker)var5_8;
                    yield ServerValue.of(guildSticker.getGuild());
                }
                yield Value.NULL;
            }
            case "type" -> {
                Object var5_9 = this.delegate;
                if (var5_9 instanceof RichSticker) {
                    RichSticker richSticker = (RichSticker)var5_9;
                    yield ValueUtil.ofEnum(richSticker.getType());
                }
                yield Value.NULL;
            }
            case "user" -> {
                Object var5_10 = this.delegate;
                if (var5_10 instanceof GuildSticker) {
                    GuildSticker guildSticker = (GuildSticker)var5_10;
                    yield UserValue.of(guildSticker.getOwner());
                }
                yield Value.NULL;
            }
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> delete(@Nullable String reason) {
        Object object = this.delegate;
        if (!(object instanceof GuildSticker)) {
            throw DiscordThrowables.genericCode(ErrorResponse.UNKNOWN_STICKER);
        }
        GuildSticker guildSticker = (GuildSticker)object;
        return guildSticker.delete().reason(reason);
    }

    @Override
    public RestAction<?> rename(String name) {
        Object object = this.delegate;
        if (!(object instanceof GuildSticker)) {
            throw DiscordThrowables.genericCode(ErrorResponse.UNKNOWN_STICKER);
        }
        GuildSticker guildSticker = (GuildSticker)object;
        return guildSticker.getManager().setName(name);
    }
}

