/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.value.BooleanValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.Optional;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.ChannelValue;
import net.replaceitem.discarpet.script.values.common.MessageableValue;
import org.jetbrains.annotations.Nullable;

public class UserValue
extends MessageableValue<User> {
    public UserValue(User user) {
        super(user);
    }

    public static Value of(@Nullable User user) {
        return ValueUtil.ofNullable(user, UserValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "user";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "name" -> StringValue.of((String)((User)this.delegate).getName());
            case "mention_tag" -> StringValue.of((String)((User)this.delegate).getAsMention());
            case "id" -> StringValue.of((String)((User)this.delegate).getId());
            case "avatar" -> StringValue.of((String)((User)this.delegate).getAvatarUrl());
            case "is_bot" -> BooleanValue.of((boolean)((User)this.delegate).isBot());
            case "is_self" -> BooleanValue.of((((User)this.delegate).getIdLong() == ((User)this.delegate).getJDA().getSelfUser().getIdLong() ? 1 : 0) != 0);
            case "private_channel" -> ChannelValue.of((Channel)ValueUtil.awaitRest(((User)this.delegate).openPrivateChannel(), "Error opening private channel with user"));
            default -> super.getProperty(property);
        };
    }

    @Override
    public Optional<MessageableValue.MessageConsumer> getMessageConsumer() {
        return Optional.of(data -> ((User)this.delegate).openPrivateChannel().flatMap(privateChannel -> privateChannel.sendMessage(data)));
    }
}

