/*
 * Decompiled with CFR 0.152.
 */
package net.replaceitem.discarpet.script.values;

import carpet.script.exception.ThrowStatement;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.Optional;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Webhook;
import net.dv8tion.jda.api.entities.WebhookClient;
import net.dv8tion.jda.api.entities.channel.Channel;
import net.dv8tion.jda.api.requests.RestAction;
import net.replaceitem.discarpet.script.exception.DiscordThrowables;
import net.replaceitem.discarpet.script.util.ValueUtil;
import net.replaceitem.discarpet.script.values.ChannelValue;
import net.replaceitem.discarpet.script.values.common.Deletable;
import net.replaceitem.discarpet.script.values.common.MessageableValue;
import net.replaceitem.discarpet.script.values.common.Renamable;
import org.jetbrains.annotations.Nullable;

public class WebhookValue
extends MessageableValue<WebhookClient<Message>>
implements Deletable,
Renamable {
    public WebhookValue(WebhookClient<Message> webhook) {
        super(webhook);
    }

    public static Value of(@Nullable WebhookClient<Message> webhookClient) {
        return ValueUtil.ofNullable(webhookClient, WebhookValue::new);
    }

    @Override
    protected String getDiscordTypeString() {
        return "webhook";
    }

    @Override
    public Value getProperty(String property) {
        return switch (property) {
            case "id" -> StringValue.of((String)((WebhookClient)this.delegate).getId());
            case "channel" -> {
                Object var5_4 = this.delegate;
                if (var5_4 instanceof Webhook) {
                    Webhook webhook = (Webhook)var5_4;
                    yield ChannelValue.of((Channel)webhook.getChannel());
                }
                yield Value.NULL;
            }
            case "type" -> {
                Object var5_5 = this.delegate;
                if (var5_5 instanceof Webhook) {
                    Webhook webhook = (Webhook)var5_5;
                    yield ValueUtil.ofEnum(webhook.getType());
                }
                yield Value.NULL;
            }
            case "token" -> StringValue.of((String)((WebhookClient)this.delegate).getToken());
            case "url" -> {
                Object var5_6 = this.delegate;
                if (var5_6 instanceof Webhook) {
                    Webhook webhook = (Webhook)var5_6;
                    yield StringValue.of((String)webhook.getUrl());
                }
                yield Value.NULL;
            }
            default -> super.getProperty(property);
        };
    }

    @Override
    public RestAction<?> delete(@Nullable String reason) {
        Object object = this.delegate;
        if (!(object instanceof Webhook)) {
            throw new ThrowStatement("Cannot delete webhook not managed by this bot", DiscordThrowables.DISCORD_EXCEPTION);
        }
        Webhook webhook = (Webhook)object;
        return webhook.delete().reason(reason);
    }

    @Override
    public RestAction<?> rename(String name) {
        Object object = this.delegate;
        if (!(object instanceof Webhook)) {
            throw new ThrowStatement("Cannot rename webhook not managed by this bot", DiscordThrowables.DISCORD_EXCEPTION);
        }
        Webhook webhook = (Webhook)object;
        return webhook.getManager().setName(name);
    }

    @Override
    public Optional<MessageableValue.MessageConsumer> getMessageConsumer() {
        return Optional.of(arg_0 -> ((WebhookClient)((WebhookClient)this.delegate)).sendMessage(arg_0));
    }
}

